/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.internal;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.extensions.internal.storage.BaSyxStorageAPI;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.operation.DelegatedInvocationManager;
import org.eclipse.basyx.submodel.restapi.vab.VABSubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProvider;

public abstract class StorageSubmodelAPI
implements ISubmodelAPI {
    protected BaSyxStorageAPI<Submodel> storageApi;
    private String identificationId;
    private DelegatedInvocationManager invocationManager;

    protected StorageSubmodelAPI(BaSyxStorageAPI<Submodel> storageAPI, String identificationId, DelegatedInvocationManager invocatonManager) {
        this.storageApi = storageAPI;
        this.identificationId = identificationId;
        this.invocationManager = invocatonManager;
    }

    public String getSubmodelId() {
        return this.identificationId;
    }

    public void setSubmodelId(String identificationId) {
        this.identificationId = identificationId;
    }

    public void setSubmodel(Submodel submodel) {
        String submodelId = submodel.getIdentification().getId();
        this.setSubmodelId(submodelId);
        this.storageApi.update((Object)submodel, submodelId);
    }

    public Submodel getSubmodel() {
        return (Submodel)this.storageApi.retrieve(this.identificationId);
    }

    public void addSubmodelElement(ISubmodelElement elem) {
        Submodel submodel = this.getSubmodel();
        submodel.addSubmodelElement(elem);
        this.storageApi.update((Object)submodel, this.identificationId);
    }

    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        VABSubmodelAPI api = new VABSubmodelAPI((IModelProvider)new VABLambdaProvider((Map)this.getSubmodel()));
        api.addSubmodelElement(idShortPath, elem);
        this.storageApi.update((Object)api.getSubmodel(), this.identificationId);
    }

    public ISubmodelElement getSubmodelElement(String idShortPath) {
        VABSubmodelAPI api = new VABSubmodelAPI((IModelProvider)new VABLambdaProvider((Map)this.getSubmodel()));
        return api.getSubmodelElement(idShortPath);
    }

    public void deleteSubmodelElement(String idShortPath) {
        VABSubmodelAPI api = new VABSubmodelAPI((IModelProvider)new VABLambdaProvider((Map)this.getSubmodel()));
        api.deleteSubmodelElement(idShortPath);
        this.storageApi.update((Object)api.getSubmodel(), this.identificationId);
    }

    public Collection<IOperation> getOperations() {
        Submodel submodel = this.getSubmodel();
        return submodel.getOperations().values();
    }

    public Collection<ISubmodelElement> getSubmodelElements() {
        Submodel submodel = this.getSubmodel();
        return submodel.getSubmodelElements().values();
    }

    public void updateSubmodelElement(String idShortPath, Object newValue) {
        VABSubmodelAPI api = new VABSubmodelAPI((IModelProvider)new VABLambdaProvider((Map)this.getSubmodel()));
        api.updateSubmodelElement(idShortPath, newValue);
        this.storageApi.update((Object)api.getSubmodel(), this.identificationId);
    }

    public Object getSubmodelElementValue(String idShortPath) {
        VABSubmodelAPI api = new VABSubmodelAPI((IModelProvider)new VABLambdaProvider((Map)this.getSubmodel()));
        return api.getSubmodelElementValue(idShortPath);
    }

    @Deprecated
    protected Object unwrapParameter(Object parameter) {
        Map map;
        if (parameter instanceof Map && (map = (Map)parameter).get("valueType") != null && map.containsKey("value")) {
            return map.get("value");
        }
        return parameter;
    }

    public Object invokeOperation(String idShortPath, Object ... params) {
        Operation operation = (Operation)SubmodelElementFacadeFactory.createSubmodelElement((Map)((Map)this.getSubmodelElement(idShortPath)));
        if (!DelegatedInvocationManager.isDelegatingOperation((Operation)operation)) {
            throw new MalformedRequestException("This backend supports only delegating operations.");
        }
        return this.invocationManager.invokeDelegatedOperation(operation, params);
    }

    public Object invokeAsync(String idShortPath, Object ... params) {
        List<String> idShorts = this.idShortsPathAsList(idShortPath);
        return this.invokeNestedOperationAsync(idShorts, params);
    }

    private List<String> idShortsPathAsList(String idShortPath) {
        String[] splittedIdShortPath = VABPathTools.splitPath((String)idShortPath);
        return Arrays.asList(splittedIdShortPath);
    }

    private Object invokeNestedOperationAsync(List<String> idShorts, Object ... params) {
        throw new MalformedRequestException("Invoke not supported by this backend");
    }

    public Object getOperationResult(String idShort, String requestId) {
        throw new MalformedRequestException("Invoke not supported by this backend");
    }

    public File getSubmodelElementFile(String idShortPath) {
        Map submodelElement = (Map)this.getSubmodelElement(idShortPath);
        String parentKey = this.getSubmodel().getIdentification().getId();
        return this.storageApi.getFile(idShortPath, parentKey, submodelElement);
    }

    public void uploadSubmodelElementFile(String idShortPath, InputStream fileStream) {
        VABSubmodelAPI api = new VABSubmodelAPI((IModelProvider)new VABLambdaProvider((Map)this.getSubmodel()));
        ISubmodelElement element = api.getSubmodelElement(idShortPath);
        this.storageApi.writeFile(idShortPath, this.getSubmodel().getIdentification().getId(), fileStream, element);
    }
}

