/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.eclipse.basyx.components.aas.internal.StorageSubmodelAPI;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPIFactory;
import org.eclipse.basyx.extensions.internal.storage.BaSyxStorageAPI;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.operation.DelegatedInvocationManager;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;

public class MongoDBSubmodelAPI
extends StorageSubmodelAPI {
    private static final String DEFAULT_CONFIG_PATH = "mongodb.properties";
    public static final String SMIDPATH = "identification.id";
    protected DelegatedInvocationManager invocationHelper;
    protected BaSyxMongoDBConfiguration config;
    protected String collection;

    public MongoDBSubmodelAPI(BaSyxMongoDBConfiguration config, String submdoelIdentificationId, MongoClient client) {
        this(config, submdoelIdentificationId, new DelegatedInvocationManager((IConnectorFactory)new HTTPConnectorFactory()), client);
    }

    public MongoDBSubmodelAPI(String submodelIdentificationId, MongoClient client) {
        this(DEFAULT_CONFIG_PATH, submodelIdentificationId, client);
    }

    public MongoDBSubmodelAPI(String submodelIdentificationId, DelegatedInvocationManager invocationHelper, MongoClient client) {
        this(DEFAULT_CONFIG_PATH, submodelIdentificationId, invocationHelper, client);
    }

    public MongoDBSubmodelAPI(BaSyxStorageAPI<Submodel> storageAPI, String identificationId, BaSyxMongoDBConfiguration config) {
        super(storageAPI, identificationId, new DelegatedInvocationManager((IConnectorFactory)new HTTPConnectorFactory()));
        this.setConfiguration(config);
    }

    public MongoDBSubmodelAPI(BaSyxStorageAPI<Submodel> storageAPI, String identificationId) {
        super(storageAPI, identificationId, new DelegatedInvocationManager((IConnectorFactory)new HTTPConnectorFactory()));
    }

    public MongoDBSubmodelAPI(String resourceConfigPath, String submodelIdentificationId, MongoClient client) {
        this(resourceConfigPath, submodelIdentificationId, new DelegatedInvocationManager((IConnectorFactory)new HTTPConnectorFactory()), client);
    }

    public MongoDBSubmodelAPI(BaSyxMongoDBConfiguration config, String submodelIdentificationId, DelegatedInvocationManager invocationHelper, MongoClient client) {
        super(MongoDBSubmodelAPI.createSubmodelStorageAPI(config, client), submodelIdentificationId, invocationHelper);
        this.setConfiguration(config);
        this.setSubmodelId(submodelIdentificationId);
        this.invocationHelper = invocationHelper;
    }

    public MongoDBSubmodelAPI(String resourceConfigPath, String submodelIdentificationId, DelegatedInvocationManager invocationHelper, MongoClient client) {
        super(MongoDBSubmodelAPI.createSubmodelStorageAPI(MongoDBSubmodelAPI.createConfig(resourceConfigPath), client), submodelIdentificationId, invocationHelper);
        this.config = MongoDBSubmodelAPI.createConfig(resourceConfigPath);
        this.setConfiguration(this.config);
        this.setSubmodelId(submodelIdentificationId);
        this.invocationHelper = invocationHelper;
    }

    @Deprecated
    public MongoDBSubmodelAPI(BaSyxMongoDBConfiguration config, String submodelIdentificationId) {
        this(config, submodelIdentificationId, new DelegatedInvocationManager((IConnectorFactory)new HTTPConnectorFactory()));
    }

    @Deprecated
    public MongoDBSubmodelAPI(BaSyxMongoDBConfiguration config, String submodelIdentificationId, DelegatedInvocationManager invocationHelper) {
        this(config, submodelIdentificationId, invocationHelper, MongoClients.create((String)config.getConnectionUrl()));
    }

    @Deprecated
    public MongoDBSubmodelAPI(String resourceConfigPath, String submodelIdentificationId) {
        this(resourceConfigPath, submodelIdentificationId, new DelegatedInvocationManager((IConnectorFactory)new HTTPConnectorFactory()));
    }

    @Deprecated
    public MongoDBSubmodelAPI(String submodelIdentificationId) {
        this(DEFAULT_CONFIG_PATH, submodelIdentificationId);
    }

    @Deprecated
    public MongoDBSubmodelAPI(String submodelIdentificationId, DelegatedInvocationManager invocationHelper) {
        this(DEFAULT_CONFIG_PATH, submodelIdentificationId, invocationHelper);
    }

    @Deprecated
    public MongoDBSubmodelAPI(String resourceConfigPath, String submodelIdentificationId, DelegatedInvocationManager invocationHelper) {
        super(MongoDBSubmodelAPI.createSubmodelStorageAPI(MongoDBSubmodelAPI.createConfig(resourceConfigPath)), submodelIdentificationId, invocationHelper);
        this.config = MongoDBSubmodelAPI.createConfig(resourceConfigPath);
        this.setConfiguration(this.config);
        this.setSubmodelId(submodelIdentificationId);
        this.invocationHelper = invocationHelper;
    }

    private static BaSyxStorageAPI<Submodel> createSubmodelStorageAPI(BaSyxMongoDBConfiguration config) {
        MongoDBBaSyxStorageAPIFactory storageAPIFactory = new MongoDBBaSyxStorageAPIFactory(config, Submodel.class, config.getSubmodelCollection());
        return storageAPIFactory.create();
    }

    private static BaSyxStorageAPI<Submodel> createSubmodelStorageAPI(BaSyxMongoDBConfiguration config, MongoClient client) {
        MongoDBBaSyxStorageAPIFactory storageAPIFactory = new MongoDBBaSyxStorageAPIFactory(config, Submodel.class, config.getSubmodelCollection(), client);
        return storageAPIFactory.create();
    }

    private static BaSyxMongoDBConfiguration createConfig(String resourceConfigPath) {
        BaSyxMongoDBConfiguration config = new BaSyxMongoDBConfiguration();
        config.loadFromResource(resourceConfigPath);
        return config;
    }

    public void setConfiguration(BaSyxMongoDBConfiguration config) {
        this.storageApi = MongoDBSubmodelAPI.createSubmodelStorageAPI(config);
    }
}

