/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPI;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPIFactory;
import org.eclipse.basyx.submodel.aggregator.SubmodelAggregator;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class MongoDBSubmodelAggregator
extends SubmodelAggregator {
    private MongoDBBaSyxStorageAPI<Submodel> storageApi;
    private MongoDBBaSyxStorageAPI<AssetAdministrationShell> aasStorageApi;
    private IIdentifier shellId;

    public MongoDBSubmodelAggregator(ISubmodelAPIFactory submodelApiFactory, BaSyxMongoDBConfiguration config, MongoClient client) {
        this(submodelApiFactory, (MongoDBBaSyxStorageAPI<Submodel>)MongoDBBaSyxStorageAPIFactory.create((String)config.getSubmodelCollection(), Submodel.class, (BaSyxMongoDBConfiguration)config, (MongoClient)client));
    }

    public MongoDBSubmodelAggregator(ISubmodelAPIFactory submodelApiFactory, BaSyxMongoDBConfiguration config, MongoClient client, IIdentifier shellId) {
        this(submodelApiFactory, (MongoDBBaSyxStorageAPI<Submodel>)MongoDBBaSyxStorageAPIFactory.create((String)config.getSubmodelCollection(), Submodel.class, (BaSyxMongoDBConfiguration)config, (MongoClient)client));
        this.aasStorageApi = MongoDBBaSyxStorageAPIFactory.create((String)config.getAASCollection(), AssetAdministrationShell.class, (BaSyxMongoDBConfiguration)config, (MongoClient)client);
        this.shellId = shellId;
    }

    public MongoDBSubmodelAggregator(ISubmodelAPIFactory submodelApiFactory, MongoDBBaSyxStorageAPI<Submodel> storageApi) {
        super(submodelApiFactory);
        this.storageApi = storageApi;
    }

    @Deprecated
    public MongoDBSubmodelAggregator(ISubmodelAPIFactory submodelApiFactory, BaSyxMongoDBConfiguration config) {
        this(submodelApiFactory, (MongoDBBaSyxStorageAPI<Submodel>)MongoDBBaSyxStorageAPIFactory.create((String)config.getSubmodelCollection(), Submodel.class, (BaSyxMongoDBConfiguration)config));
    }

    public void deleteSubmodelByIdentifier(IIdentifier submodelIdentifier) {
        this.storageApi.delete(submodelIdentifier.getId());
    }

    public void deleteSubmodelByIdShort(String idShort) {
        ISubmodel submodel = this.getSubmodelbyIdShort(idShort);
        this.storageApi.delete(submodel.getIdentification().getId());
    }

    public Collection<ISubmodel> getSubmodelList() {
        if (this.shellId == null) {
            return this.returnAllSubmodels();
        }
        AssetAdministrationShell shell = (AssetAdministrationShell)this.aasStorageApi.retrieve(this.shellId.getId());
        Collection submodelRefs = shell.getSubmodelReferences();
        if (submodelRefs.isEmpty()) {
            return this.findSubmodelsWithGivenParentId();
        }
        List submodelIds = submodelRefs.stream().map(ref -> this.getLastKeyFromReference((IReference)ref).getValue()).collect(Collectors.toList());
        return submodelIds.stream().map(sm -> (Submodel)this.storageApi.retrieve(sm)).collect(Collectors.toList());
    }

    private List<ISubmodel> returnAllSubmodels() {
        return this.storageApi.retrieveAll().stream().map(submodel -> submodel).collect(Collectors.toList());
    }

    private List<ISubmodel> findSubmodelsWithGivenParentId() {
        return this.storageApi.retrieveAll().stream().filter(submodel -> {
            IReference parentRef = submodel.getParent();
            return parentRef != null && ((IKey)parentRef.getKeys().get(0)).getValue().equals(this.shellId.getId());
        }).collect(Collectors.toList());
    }

    private IKey getLastKeyFromReference(IReference reference) {
        List keys = reference.getKeys();
        IKey lastKey = (IKey)keys.get(keys.size() - 1);
        return lastKey;
    }

    public ISubmodel getSubmodel(IIdentifier identifier) throws ResourceNotFoundException {
        return (ISubmodel)this.storageApi.retrieve(identifier.getId());
    }

    public void createSubmodel(Submodel submodel) {
        this.storageApi.createOrUpdate((Object)submodel);
    }

    public void updateSubmodel(Submodel submodel) throws ResourceNotFoundException {
        this.storageApi.createOrUpdate((Object)submodel);
    }

    public void createSubmodel(ISubmodelAPI submodelAPI) {
        this.storageApi.createOrUpdate((Object)((Submodel)submodelAPI.getSubmodel()));
    }

    public ISubmodel getSubmodelbyIdShort(String idShort) throws ResourceNotFoundException {
        Optional<ISubmodel> submodelOptional = this.getSubmodelList().stream().filter(submodel -> submodel.getIdShort().equals(idShort)).findAny();
        if (submodelOptional.isEmpty()) {
            throw new ResourceNotFoundException("The submodel with idShort '" + idShort + "' could not be found");
        }
        return submodelOptional.get();
    }

    public ISubmodelAPI getSubmodelAPIById(IIdentifier identifier) throws ResourceNotFoundException {
        Submodel submodel = (Submodel)this.getSubmodel(identifier);
        return this.submodelApiFactory.create(submodel);
    }

    public ISubmodelAPI getSubmodelAPIByIdShort(String idShort) throws ResourceNotFoundException {
        Submodel submodel = (Submodel)this.getSubmodelbyIdShort(idShort);
        return this.submodelApiFactory.create(submodel);
    }
}

