/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.map.descriptor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;

public class AASDescriptor
extends ModelDescriptor {
    public static final String MODELTYPE = "AssetAdministrationShellDescriptor";
    public static final String ASSET = "asset";

    public AASDescriptor(Map<String, Object> map) {
        super(map);
        this.validate(map);
        this.putAll(map);
    }

    protected AASDescriptor() {
    }

    public AASDescriptor(IAssetAdministrationShell assetAdministrationShell, String endpoint) {
        this(assetAdministrationShell.getIdShort(), assetAdministrationShell.getIdentification(), assetAdministrationShell.getAsset(), endpoint);
    }

    public AASDescriptor(String idShort, IIdentifier aasid, IAsset asset, String httpEndpoint) {
        super(idShort, aasid, httpEndpoint);
        this.put(ASSET, asset);
        this.put("submodels", new HashSet());
        this.putAll(new ModelType(MODELTYPE));
    }

    public AASDescriptor(String idShort, IIdentifier aasid, String httpEndpoint) {
        super(idShort, aasid, httpEndpoint);
        this.put("submodels", new HashSet());
        this.putAll(new ModelType(MODELTYPE));
    }

    public AASDescriptor(IIdentifier aasid, String httpEndpoint) {
        this("", aasid, httpEndpoint);
    }

    public AASDescriptor addSubmodelDescriptor(SubmodelDescriptor desc) {
        Collection submodelDescriptors = (Collection)this.get("submodels");
        submodelDescriptors.add(desc);
        this.put("submodels", submodelDescriptors);
        return this;
    }

    public void removeSubmodelDescriptor(String idShort) {
        Optional<SubmodelDescriptor> toRemove = this.getSubmodelDescriptors().stream().filter(x -> x.getIdShort().equals(idShort)).findAny();
        if (toRemove.isPresent()) {
            ((Collection)this.get("submodels")).remove(toRemove.get());
        }
    }

    public void removeSubmodelDescriptor(IIdentifier id) {
        Optional<SubmodelDescriptor> toRemove = this.getSubmodelDescriptors().stream().filter(x -> x.getIdentifier().getId().equals(id.getId())).findAny();
        if (toRemove.isPresent()) {
            ((Collection)this.get("submodels")).remove(toRemove.get());
        }
    }

    public SubmodelDescriptor getSubmodelDescriptorFromIdentifierId(String subModelId) {
        Collection smDescriptorMaps = (Collection)this.get("submodels");
        for (Map smDescriptorMap : smDescriptorMaps) {
            IIdentifier id = Identifiable.createAsFacade(smDescriptorMap, KeyElements.SUBMODEL).getIdentification();
            if (!id.getId().equals(subModelId)) continue;
            return new SubmodelDescriptor(smDescriptorMap);
        }
        return null;
    }

    public SubmodelDescriptor getSubmodelDescriptorFromIdShort(String idShort) {
        return this.getSubmodelDescriptors().stream().filter(x -> x.getIdShort().equals(idShort)).findAny().orElse(null);
    }

    public SubmodelDescriptor getSubmodelDescriptor(ModelUrn submodelUrn) {
        return this.getSubmodelDescriptorFromIdentifierId(submodelUrn.getURN());
    }

    public Collection<SubmodelDescriptor> getSubmodelDescriptors() {
        Collection descriptors = (Collection)this.get("submodels");
        return descriptors.stream().map(SubmodelDescriptor::new).collect(Collectors.toSet());
    }

    @Override
    protected String getModelType() {
        return MODELTYPE;
    }

    public IAsset getAsset() {
        Map assetModel = (Map)this.get(ASSET);
        return Asset.createAsFacade(assetModel);
    }

    @Override
    public void validate(Map<String, Object> map) {
        super.validate(map);
        if (!map.containsKey("submodels")) {
            map.put("submodels", new HashSet());
        } else if (map.containsKey("submodels") && !(map.get("submodels") instanceof Collection)) {
            throw new MalformedRequestException("Passed entry for submodels is not a list of submodelDescriptors!");
        }
    }

    public static AASDescriptor createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        AASDescriptor ret = new AASDescriptor();
        ret.setMap(map);
        return ret;
    }
}

