/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.aasxupload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.bundle.AASBundleHelper;
import org.eclipse.basyx.aas.factory.aasx.AASXToMetamodelConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.extensions.aas.aggregator.aasxupload.api.IAASAggregatorAASXUpload;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.xml.sax.SAXException;

public class AASAggregatorAASXUpload
implements IAASAggregatorAASXUpload {
    private IAASAggregator aggregator;

    public AASAggregatorAASXUpload(IAASAggregator aggregator) {
        this.aggregator = aggregator;
    }

    @Override
    public void uploadAASX(InputStream aasxStream) {
        try (AASXToMetamodelConverter converter = new AASXToMetamodelConverter(aasxStream);){
            Set<AASBundle> bundles = converter.retrieveAASBundles();
            AASBundleHelper.integrate(this, bundles);
            this.uploadFilesInAASX(converter);
        }
        catch (Exception e) {
            throw new MalformedRequestException("invalid request to aasx path without valid aasx input stream");
        }
    }

    public void uploadFilesInAASX(AASXToMetamodelConverter converter) throws InvalidFormatException, IOException, ParserConfigurationException, SAXException {
        converter.retrieveAASBundles().forEach(aasBundle -> aasBundle.getSubmodels().forEach(submodel -> submodel.getSubmodelElements().values().forEach(submodelElement -> this.uploadNestedFiles(aasBundle.getAAS().getIdentification(), converter, (ISubmodelElement)submodelElement, this.getSubmodelElementPath(submodel.getIdShort())))));
    }

    private void uploadNestedFiles(IIdentifier aasIdentification, AASXToMetamodelConverter converter, ISubmodelElement submodelElement, String submodelCollectionPath) {
        if (submodelElement instanceof File) {
            this.uploadFileInSubmodelElement(aasIdentification, converter, (File)submodelElement, submodelCollectionPath + "/" + submodelElement.getIdShort());
        } else if (submodelElement instanceof SubmodelElementCollection) {
            this.uploadFileInSubmodelElementCollection(aasIdentification, converter, submodelElement, submodelCollectionPath + "/" + submodelElement.getIdShort());
        }
    }

    private void uploadFileInSubmodelElement(IIdentifier aasIdentification, AASXToMetamodelConverter converter, File submodelElement, String submodelElementPath) {
        try {
            this.getAASProvider(aasIdentification).createValue(submodelElementPath + "/upload", converter.retrieveFileInputStream(submodelElement.getValue()));
        }
        catch (IOException | InvalidFormatException e) {
            e.printStackTrace();
        }
    }

    private void uploadFileInSubmodelElementCollection(IIdentifier aasIdentification, AASXToMetamodelConverter converter, ISubmodelElement submodelCollection, String submodelCollectionPath) {
        ISubmodelElementCollection smeCollection = (ISubmodelElementCollection)submodelCollection;
        smeCollection.getSubmodelElements().values().forEach(submodelElement -> this.uploadNestedFiles(aasIdentification, converter, (ISubmodelElement)submodelElement, submodelCollectionPath));
    }

    private String getSubmodelElementPath(String submodelIdshort) {
        return "aas/submodels/" + submodelIdshort + "/submodel/submodelElements/";
    }

    @Override
    public Collection<IAssetAdministrationShell> getAASList() {
        return this.aggregator.getAASList();
    }

    @Override
    public IAssetAdministrationShell getAAS(IIdentifier aasId) throws ResourceNotFoundException {
        return this.aggregator.getAAS(aasId);
    }

    @Override
    public IModelProvider getAASProvider(IIdentifier aasId) throws ResourceNotFoundException {
        return this.aggregator.getAASProvider(aasId);
    }

    @Override
    public void createAAS(AssetAdministrationShell aas) {
        this.aggregator.createAAS(aas);
    }

    @Override
    public void updateAAS(AssetAdministrationShell aas) throws ResourceNotFoundException {
        this.aggregator.updateAAS(aas);
    }

    @Override
    public void deleteAAS(IIdentifier aasId) {
        this.aggregator.deleteAAS(aasId);
    }
}

