/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.mqtt;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.basyx.aas.aggregator.observing.IAASAggregatorObserverV2;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.extensions.aas.aggregator.mqtt.MqttV2AASAggregatorTopicFactory;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.Serializer;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttV2AASAggregatorObserver
extends MqttEventService
implements IAASAggregatorObserverV2 {
    private static Logger logger = LoggerFactory.getLogger(MqttV2AASAggregatorObserver.class);
    private MqttV2AASAggregatorTopicFactory topicFactory;
    private Serializer payloadSerializer;

    public MqttV2AASAggregatorObserver(MqttClient client, MqttV2AASAggregatorTopicFactory topicFactory) throws MqttException {
        this(client, topicFactory, MqttV2AASAggregatorObserver.createGSONTools());
    }

    public MqttV2AASAggregatorObserver(MqttClient client, MqttV2AASAggregatorTopicFactory topicFactory, Serializer payloadSerializer) throws MqttException {
        super(client);
        this.topicFactory = topicFactory;
        this.payloadSerializer = payloadSerializer;
        logger.info("Create new MQTT AAS Aggregator Observer for endpoint " + client.getServerURI());
    }

    private static GSONTools createGSONTools() {
        return new GSONTools(new DefaultTypeFactory(), false, false);
    }

    @Override
    public void aasCreated(AssetAdministrationShell shell, String repoId) {
        if (shell instanceof Map) {
            IAssetAdministrationShell copy = this.removeConceptDictionaries(shell);
            this.sendMqttMessage(this.topicFactory.createCreateAASTopic(repoId), this.serializePayload(copy));
        } else {
            this.sendMqttMessage(this.topicFactory.createCreateAASTopic(repoId), this.serializePayload(shell));
        }
    }

    @Override
    public void aasUpdated(AssetAdministrationShell shell, String repoId) {
        if (shell instanceof Map) {
            IAssetAdministrationShell copy = this.removeConceptDictionaries(shell);
            this.sendMqttMessage(this.topicFactory.createUpdateAASTopic(repoId), this.serializePayload(copy));
        } else {
            this.sendMqttMessage(this.topicFactory.createUpdateAASTopic(repoId), this.serializePayload(shell));
        }
    }

    @Override
    public void aasDeleted(IAssetAdministrationShell shell, String repoId) {
        if (shell instanceof Map) {
            IAssetAdministrationShell copy = this.removeConceptDictionaries(shell);
            this.sendMqttMessage(this.topicFactory.createDeleteAASTopic(repoId), this.serializePayload(copy));
        } else {
            this.sendMqttMessage(this.topicFactory.createDeleteAASTopic(repoId), this.serializePayload(shell));
        }
    }

    private IAssetAdministrationShell removeConceptDictionaries(IAssetAdministrationShell shell) {
        Map map = (Map)((Object)shell);
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(map);
        AssetAdministrationShell aas = AssetAdministrationShell.createAsFacade(copy);
        aas.setConceptDictionary(Collections.emptyList());
        return aas;
    }

    private String serializePayload(IAssetAdministrationShell shell) {
        return this.payloadSerializer.serialize(shell);
    }
}

