/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.registration.mqtt;

import java.util.StringJoiner;
import org.eclipse.basyx.extensions.shared.encoding.IEncoder;
import org.eclipse.basyx.extensions.shared.mqtt.AbstractMqttV2TopicFactory;

public class MqttV2AASRegistryTopicFactory
extends AbstractMqttV2TopicFactory {
    private static final String AASREGISTRY = "aas-registry";
    private static final String SHELLS = "shells";
    private static final String SUBMODELS = "submodels";
    private static final String CREATED = "created";
    private static final String UPDATED = "updated";
    private static final String DELETED = "deleted";

    public MqttV2AASRegistryTopicFactory(IEncoder encoder) {
        super(encoder);
    }

    public String createCreateAASTopic(String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SHELLS).add(CREATED).toString();
    }

    public String createCreateSubmodelTopic(String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SUBMODELS).add(CREATED).toString();
    }

    public String createCreateSubmodelTopicWithAASId(String aasId, String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SHELLS).add(this.encodeId(aasId)).add(SUBMODELS).add(CREATED).toString();
    }

    public String createUpdateAASTopic(String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SHELLS).add(UPDATED).toString();
    }

    public String createUpdateSubmodelTopic(String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SUBMODELS).add(UPDATED).toString();
    }

    public String createUpdateSubmodelTopicWithAASId(String aasId, String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SHELLS).add(this.encodeId(aasId)).add(SUBMODELS).add(UPDATED).toString();
    }

    public String createDeleteAASTopic(String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SHELLS).add(DELETED).toString();
    }

    public String createDeleteSubmodelTopic(String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SUBMODELS).add(DELETED).toString();
    }

    public String createDeleteSubmodelTopicWithAASId(String aasId, String registryId) {
        return new StringJoiner("/", "", "").add(AASREGISTRY).add(registryId).add(SHELLS).add(this.encodeId(aasId)).add(SUBMODELS).add(DELETED).toString();
    }
}

