/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRule;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleSet;
import org.eclipse.basyx.extensions.shared.authorization.internal.TargetInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredefinedSetRbacRuleChecker
implements IRbacRuleChecker {
    private static final Logger logger = LoggerFactory.getLogger(PredefinedSetRbacRuleChecker.class);
    private final RbacRuleSet rbacRuleSet;

    public PredefinedSetRbacRuleChecker(RbacRuleSet rbacRuleSet) {
        this.rbacRuleSet = rbacRuleSet;
    }

    @Override
    public boolean checkRbacRuleIsSatisfied(List<String> roles, String action, TargetInformation targetInformation) {
        Optional<RbacRule> matchingRule = this.getMatchingRules(roles, action, targetInformation).findAny();
        logger.info("roles: {}, action: {}, targetInfo: {} - matching-rule?: {}", new Object[]{roles, action, targetInformation, matchingRule});
        return matchingRule.isPresent();
    }

    private Stream<RbacRule> getMatchingRules(List<String> roles, String action, TargetInformation targetInformation) {
        return this.rbacRuleSet.getRules().parallelStream().filter(rbacRule -> this.checkRolesMatchRbacRule((RbacRule)rbacRule, roles)).filter(rbacRule -> this.checkActionMatchesRbacRule((RbacRule)rbacRule, action)).filter(rbacRule -> this.checkRbacRuleMatchesTargetInformation((RbacRule)rbacRule, targetInformation));
    }

    private boolean checkRolesMatchRbacRule(RbacRule rbacRule, List<String> roles) {
        return rbacRule.getRole().equals("*") || roles != null && roles.stream().anyMatch(role -> rbacRule.getRole().equals(role));
    }

    private boolean checkActionMatchesRbacRule(RbacRule rbacRule, String action) {
        return rbacRule.getAction().equals("*") || rbacRule.getAction().equals(action);
    }

    private boolean checkRbacRuleMatchesTargetInformation(RbacRule rbacRule, TargetInformation matchTargetInformation) {
        TargetInformation rbacRuleTargetInformation = rbacRule.getTargetInformation();
        if (!rbacRuleTargetInformation.getClass().isAssignableFrom(matchTargetInformation.getClass())) {
            return false;
        }
        Map<String, String> matchTargetInformationMap = matchTargetInformation.toMap();
        Map<String, String> rbacRuleTargetInformationMap = rbacRule.getTargetInformation().toMap();
        for (Map.Entry<String, String> matchTargetInformationMapEntry : matchTargetInformationMap.entrySet()) {
            String key = matchTargetInformationMapEntry.getKey();
            String matchTargetInformationSingleValue = matchTargetInformationMapEntry.getValue();
            String rbacRuleValue = rbacRuleTargetInformationMap.get(key);
            if (this.checkRegexStringMatch(rbacRuleValue, matchTargetInformationSingleValue)) continue;
            return false;
        }
        return true;
    }

    private boolean checkRegexStringMatch(String actualString, String requiredString) {
        if (requiredString == null) {
            return true;
        }
        if (actualString == null) {
            return false;
        }
        return actualString.equals("*") || requiredString.matches(actualString.replaceAll("\\*", "[A-Za-z0-9.]+"));
    }
}

