/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.aggregator.authorization;

import java.util.Collection;
import org.eclipse.basyx.extensions.shared.authorization.SecurityContextAuthorizer;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class AuthorizedSubmodelAggregator
implements ISubmodelAggregator {
    private static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-aggregator:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-aggregator:write";
    private final SecurityContextAuthorizer authorizer = new SecurityContextAuthorizer();
    private ISubmodelAggregator decoratedSubmodelAggregator;

    public AuthorizedSubmodelAggregator(ISubmodelAggregator decoratedSubmodelAggregator) {
        this.decoratedSubmodelAggregator = decoratedSubmodelAggregator;
    }

    @Override
    public Collection<ISubmodel> getSubmodelList() {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAggregator.getSubmodelList();
    }

    @Override
    public ISubmodel getSubmodel(IIdentifier identifier) throws ResourceNotFoundException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAggregator.getSubmodel(identifier);
    }

    @Override
    public ISubmodel getSubmodelbyIdShort(String idShort) throws ResourceNotFoundException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAggregator.getSubmodelbyIdShort(idShort);
    }

    @Override
    public ISubmodelAPI getSubmodelAPIById(IIdentifier identifier) throws ResourceNotFoundException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAggregator.getSubmodelAPIById(identifier);
    }

    @Override
    public ISubmodelAPI getSubmodelAPIByIdShort(String idShort) throws ResourceNotFoundException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAggregator.getSubmodelAPIByIdShort(idShort);
    }

    @Override
    public void createSubmodel(Submodel submodel) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAggregator.createSubmodel(submodel);
    }

    @Override
    public void createSubmodel(ISubmodelAPI submodelAPI) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAggregator.createSubmodel(submodelAPI);
    }

    @Override
    public void updateSubmodel(Submodel submodel) throws ResourceNotFoundException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAggregator.updateSubmodel(submodel);
    }

    @Override
    public void deleteSubmodelByIdentifier(IIdentifier identifier) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAggregator.deleteSubmodelByIdentifier(identifier);
    }

    @Override
    public void deleteSubmodelByIdShort(String idShort) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAggregator.deleteSubmodelByIdShort(idShort);
    }
}

