/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.api.dataspecification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.LangStringsXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IDataSpecificationIEC61360Content;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IValueReferencePair;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.enums.DataTypeIEC61360;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.enums.LevelType;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.dataspecification.DataSpecificationIEC61360Content;
import org.eclipse.basyx.submodel.metamodel.map.dataspecification.ValueReferencePair;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSpecificationIEC61360XMLConverter {
    public static final String IEC61360_LANGSTRING = "IEC61360:langString";
    public static final String IEC61360_KEYS = "IEC61360:keys";
    public static final String IEC61360_KEY = "IEC61360:key";
    public static final String IEC61360_PREFERREDNAME = "IEC61360:preferredName";
    public static final String IEC61360_SHORTNAME = "IEC61360:shortName";
    public static final String IEC61360_UNIT = "IEC61360:unit";
    public static final String IEC61360_UNITID = "IEC61360:unitId";
    public static final String IEC61360_SOURCEOFDEFINITION = "IEC61360:sourceOfDefinition";
    public static final String IEC61360_SYMBOL = "IEC61360:symbol";
    public static final String IEC61360_DATATYPE = "IEC61360:dataType";
    public static final String IEC61360_DEFINITION = "IEC61360:definition";
    public static final String IEC61360_VALUEFORMAT = "IEC61360:valueFormat";
    public static final String IEC61360_VALUELIST = "IEC61360:valueList";
    public static final String IEC61360_REFERENCEPAIR = "IEC61360:valueReferencePair";
    public static final String IEC61360_PAIRVALUE = "IEC61360:value";
    public static final String IEC61360_PAIRID = "IEC61360:valueId";
    public static final String IEC61360_VALUE = "IEC61360:value";
    public static final String IEC61360_VALUEID = "IEC61360:valueId";
    public static final String IEC61360_LEVELTYPE = "IEC61360:levelType";

    public static DataSpecificationIEC61360Content parseDataSpecificationContent(Map<String, Object> contentObj) {
        DataSpecificationIEC61360Content spec = new DataSpecificationIEC61360Content();
        if (contentObj == null) {
            return spec;
        }
        LangStrings preferredName = LangStringsXMLConverter.parseLangStrings(contentObj.get(IEC61360_PREFERREDNAME), IEC61360_LANGSTRING);
        spec.setPreferredName(preferredName);
        LangStrings shortName = LangStringsXMLConverter.parseLangStrings(contentObj.get(IEC61360_SHORTNAME), IEC61360_LANGSTRING);
        spec.setShortName(shortName);
        spec.setUnit(XMLHelper.getString(contentObj.get(IEC61360_UNIT)));
        spec.setUnitId(ReferenceXMLConverter.parseReference((Map)contentObj.get(IEC61360_UNITID), IEC61360_KEYS, IEC61360_KEY));
        spec.setSourceOfDefinition(XMLHelper.getString(contentObj.get(IEC61360_SOURCEOFDEFINITION)));
        spec.setSymbol(XMLHelper.getString(contentObj.get(IEC61360_SYMBOL)));
        spec.setDataType(DataTypeIEC61360.fromString(XMLHelper.getString(contentObj.get(IEC61360_DATATYPE))));
        LangStrings definition = LangStringsXMLConverter.parseLangStrings(contentObj.get(IEC61360_DEFINITION), IEC61360_LANGSTRING);
        spec.setDefinition(definition);
        spec.setValueFormat(XMLHelper.getString(contentObj.get(IEC61360_VALUEFORMAT)));
        spec.setValueList(DataSpecificationIEC61360XMLConverter.parseValueList((Map)contentObj.get(IEC61360_VALUELIST)));
        spec.setValue(XMLHelper.getString(contentObj.get("IEC61360:value")));
        spec.setValueId(ReferenceXMLConverter.parseReference((Map)contentObj.get("IEC61360:valueId"), IEC61360_KEYS, IEC61360_KEY));
        spec.setLevelType(LevelType.fromString(XMLHelper.getString(contentObj.get(IEC61360_LEVELTYPE))));
        return spec;
    }

    private static Collection<IValueReferencePair> parseValueList(Map<String, Object> xmlObj) {
        if (xmlObj == null) {
            return new ArrayList<IValueReferencePair>();
        }
        List<Map<String, Object>> xmlPairs = XMLHelper.getList(xmlObj.get(IEC61360_REFERENCEPAIR));
        ArrayList<IValueReferencePair> pairs = new ArrayList<IValueReferencePair>();
        for (Map<String, Object> xmlPair : xmlPairs) {
            ValueReferencePair pair = new ValueReferencePair();
            pair.setValue(XMLHelper.getString(xmlPair.get("IEC61360:value")));
            pair.setValueId(ReferenceXMLConverter.parseReference((Map)xmlPair.get("IEC61360:valueId")));
            pairs.add(pair);
        }
        return pairs;
    }

    public static void populateIEC61360ContentXML(Document document, Element contentRoot, IDataSpecificationIEC61360Content content) {
        LevelType lType;
        IReference valueId;
        String value;
        Collection<IValueReferencePair> valueList;
        String valueFormat;
        LangStrings definition;
        DataTypeIEC61360 dtype;
        String symbol;
        String sod;
        IReference unitId;
        String unit;
        LangStrings shortName;
        LangStrings preferredName = content.getPreferredName();
        if (preferredName != null && !preferredName.isEmpty()) {
            Element preferredNameRoot = document.createElement(IEC61360_PREFERREDNAME);
            LangStringsXMLConverter.buildLangStringsXML(document, preferredNameRoot, IEC61360_LANGSTRING, preferredName);
            contentRoot.appendChild(preferredNameRoot);
        }
        if ((shortName = content.getShortName()) != null && !shortName.isEmpty()) {
            Element shortNameRoot = document.createElement(IEC61360_SHORTNAME);
            LangStringsXMLConverter.buildLangStringsXML(document, shortNameRoot, IEC61360_LANGSTRING, shortName);
            contentRoot.appendChild(shortNameRoot);
        }
        if ((unit = content.getUnit()) != null && !unit.isEmpty()) {
            Element unitRoot = document.createElement(IEC61360_UNIT);
            unitRoot.appendChild(document.createTextNode(unit));
            contentRoot.appendChild(unitRoot);
        }
        if ((unitId = content.getUnitId()) != null) {
            Element unitIdRoot = document.createElement(IEC61360_UNITID);
            unitIdRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, unitId, IEC61360_KEYS, IEC61360_KEY));
            contentRoot.appendChild(unitIdRoot);
        }
        if ((sod = content.getSourceOfDefinition()) != null && !sod.isEmpty()) {
            Element sodRoot = document.createElement(IEC61360_SOURCEOFDEFINITION);
            sodRoot.appendChild(document.createTextNode(sod));
            contentRoot.appendChild(sodRoot);
        }
        if ((symbol = content.getSymbol()) != null && !symbol.isEmpty()) {
            Element symbolRoot = document.createElement(IEC61360_SYMBOL);
            symbolRoot.appendChild(document.createTextNode(symbol));
            contentRoot.appendChild(symbolRoot);
        }
        if ((dtype = content.getDataType()) != null) {
            Element dataTypeRoot = document.createElement(IEC61360_DATATYPE);
            dataTypeRoot.appendChild(document.createTextNode(dtype.toString()));
            contentRoot.appendChild(dataTypeRoot);
        }
        if ((definition = content.getDefinition()) != null && !definition.isEmpty()) {
            Element definitionRoot = document.createElement(IEC61360_DEFINITION);
            LangStringsXMLConverter.buildLangStringsXML(document, definitionRoot, IEC61360_LANGSTRING, definition);
            contentRoot.appendChild(definitionRoot);
        }
        if ((valueFormat = content.getValueFormat()) != null && !valueFormat.isEmpty()) {
            Element valueFormatRoot = document.createElement(IEC61360_VALUEFORMAT);
            valueFormatRoot.appendChild(document.createTextNode(valueFormat));
            contentRoot.appendChild(valueFormatRoot);
        }
        if ((valueList = content.getValueList()) != null && !valueList.isEmpty()) {
            Element valueListRoot = document.createElement(IEC61360_VALUELIST);
            DataSpecificationIEC61360XMLConverter.buildValueListXML(document, valueListRoot, valueList);
            contentRoot.appendChild(valueListRoot);
        }
        if ((value = content.getValue()) != null && !value.isEmpty()) {
            Element valueRoot = document.createElement("IEC61360:value");
            valueRoot.appendChild(document.createTextNode(value));
            contentRoot.appendChild(valueRoot);
        }
        if ((valueId = content.getValueId()) != null) {
            Element valueIdRoot = document.createElement("IEC61360:valueId");
            valueIdRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, valueId, IEC61360_KEYS, IEC61360_KEY));
            contentRoot.appendChild(valueIdRoot);
        }
        if ((lType = content.getLevelType()) != null) {
            Element levelTypeRoot = document.createElement(IEC61360_LEVELTYPE);
            levelTypeRoot.appendChild(document.createTextNode(lType.toString()));
            contentRoot.appendChild(levelTypeRoot);
        }
    }

    private static void buildValueListXML(Document document, Element valueListRoot, Collection<IValueReferencePair> valueList) {
        for (IValueReferencePair pair : valueList) {
            Element pairRoot = document.createElement(IEC61360_REFERENCEPAIR);
            IReference valueId = pair.getValueId();
            Element valueIdRoot = document.createElement("IEC61360:valueId");
            valueIdRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, valueId, IEC61360_KEYS, IEC61360_KEY));
            pairRoot.appendChild(valueIdRoot);
            Element valueRoot = document.createElement("IEC61360:value");
            valueRoot.appendChild(document.createTextNode(pair.getValue()));
            pairRoot.appendChild(valueRoot);
            valueListRoot.appendChild(pairRoot);
        }
    }
}

