/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.connector;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.basyx.vab.protocol.http.connector.IAuthorizationSupplier;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class OAuth2ClientCredentialsBasedAuthorizationSupplier
implements IAuthorizationSupplier {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2ClientCredentialsBasedAuthorizationSupplier.class);
    private static final String SCOPE_DELIMITER = " ";
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private final Client client = new JerseyClientBuilder().build();
    private final JsonParser jsonParser;
    private final String tokenEndpoint;
    private final Set<String> scopes;
    private final AtomicReference<JWT> cachedAccessTokenReference;

    public OAuth2ClientCredentialsBasedAuthorizationSupplier(String tokenEndpoint, String clientId, String clientSecret, Set<String> scopes) {
        this.client.register((Object)HttpAuthenticationFeature.basicBuilder().credentials(clientId, clientSecret).build());
        this.jsonParser = new JsonParser();
        this.tokenEndpoint = tokenEndpoint;
        this.scopes = new HashSet<String>(scopes);
        this.cachedAccessTokenReference = new AtomicReference();
    }

    @Override
    public Optional<String> getAuthorization() {
        return Optional.ofNullable(this.getAccessToken()).map(JWT::getParsedString).map(str -> BEARER_TOKEN_PREFIX + str);
    }

    @Nullable
    private JWT getAccessToken() {
        JWT cachedAccessToken = this.cachedAccessTokenReference.get();
        if (this.isValidToken(cachedAccessToken)) {
            return cachedAccessToken;
        }
        JWT freshAccessToken = this.getFreshAccessToken();
        this.cachedAccessTokenReference.set(freshAccessToken);
        return freshAccessToken;
    }

    private boolean isValidToken(@Nullable JWT jwt) {
        return jwt != null && !this.isExpiredToken(jwt);
    }

    private boolean isExpiredToken(JWT jwt) {
        try {
            Date expirationTime = jwt.getJWTClaimsSet().getExpirationTime();
            if (expirationTime == null) {
                return false;
            }
            return this.isPastDate(expirationTime);
        }
        catch (ParseException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    private boolean isPastDate(Date date) {
        Date now = new Date();
        return now.after(date);
    }

    @Nullable
    private JWT getFreshAccessToken() {
        try {
            Response response = this.requestToken();
            String accessToken = this.getAccessTokenFromResponse(response);
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                return JWTParser.parse((String)accessToken);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Response requestToken() {
        Form form = new Form().param("grant_type", "client_credentials");
        if (!this.scopes.isEmpty()) {
            form = form.param("scope", String.join((CharSequence)SCOPE_DELIMITER, this.scopes));
        }
        return this.client.target(this.tokenEndpoint).request().post(Entity.form((Form)form));
    }

    private String getAccessTokenFromResponse(Response response) {
        String responseString = (String)response.readEntity(String.class);
        try {
            JsonElement responseEl = this.jsonParser.parse(responseString);
            return responseEl.getAsJsonObject().get("access_token").getAsString();
        }
        catch (JsonParseException e) {
            logger.error("server did not return a parseable json but instead: {}", (Object)responseString);
            throw e;
        }
    }
}

