/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.aas.basyx.VersionAdjustment;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.haskind.ModelingKind;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;

public class BaSyxOperation
extends BaSyxSubmodelElement
implements Operation {
    private IOperation operation;

    private BaSyxOperation() {
    }

    BaSyxOperation(IOperation operation) {
        this.operation = operation;
    }

    IOperation getOperation() {
        return this.operation;
    }

    public String getIdShort() {
        return this.operation.getIdShort();
    }

    public int getInArgsCount() {
        return this.operation.getInputVariables().size();
    }

    public int getOutArgsCount() {
        int result = this.operation.getOutputVariables().size();
        if (this.isVoid()) {
            result = 0;
        }
        return result;
    }

    private boolean isVoid() {
        int noneCount = 0;
        for (IOperationVariable v : this.operation.getOutputVariables()) {
            ValueType type;
            if (!(v.getValue() instanceof Property) || (type = ((Property)v.getValue()).getValueType()) != null && type != ValueType.None) continue;
            ++noneCount;
        }
        return this.operation.getOutputVariables().size() == 1 && noneCount == 1;
    }

    public int getInOutArgsCount() {
        return this.operation.getInOutputVariables().size();
    }

    public int getArgsCount() {
        return this.getInArgsCount() + this.getOutArgsCount() + this.getInOutArgsCount();
    }

    public Object invoke(Object ... args) throws ExecutionException {
        try {
            ISubmodelElement outVar;
            ValueType type = null;
            if (this.operation.getOutputVariables().size() > 0 && (outVar = ((IOperationVariable)this.operation.getOutputVariables().iterator().next()).getValue()) instanceof Property) {
                type = ((Property)outVar).getValueType();
            }
            return Tools.translateValueFromBaSyx(VersionAdjustment.operationInvoke(this.operation, args), type);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    IOperation getSubmodelElement() {
        return this.operation;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitOperation((Operation)this);
    }

    public String getSemanticId(boolean stripPrefix) {
        return Tools.translateReference(this.operation.getSemanticId(), stripPrefix);
    }

    public void setSemanticId(String semanticId) {
        IReference ref = Tools.translateReference(semanticId);
        if (ref != null && this.operation instanceof org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation) {
            ((org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation)this.operation).setSemanticId(ref);
        }
    }

    public static class BaSxyOperationBuilder
    implements Operation.OperationBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxOperation instance;
        private org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation operation;
        private List<OperationVariable> inputVariables;
        private List<OperationVariable> outputVariables;
        private List<OperationVariable> inOutVariables;

        BaSxyOperationBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort) {
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxOperation();
            this.operation = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation();
            this.operation.setIdShort(Tools.checkId(idShort));
        }

        public BaSyxSubmodelElementContainerBuilder<?> getParentBuilder() {
            return this.parentBuilder;
        }

        private OperationVariable createOperationVariable(String idShort, Type type, Consumer<Property.PropertyBuilder> init) {
            Property prop = new Property();
            prop.setIdShort(idShort);
            VersionAdjustment.setPropertyKind(prop, ModelingKind.TEMPLATE);
            if (null != type) {
                prop.setValueType(Tools.translate(type));
            }
            if (null != init) {
                BaSyxProperty.BaSyxPropertyBuilder builder = new BaSyxProperty.BaSyxPropertyBuilder(null, new BaSyxProperty((IProperty)prop));
                init.accept(builder);
            }
            return new OperationVariable((SubmodelElement)prop);
        }

        public Operation.OperationBuilder addInputVariable(String idShort, Type type, Consumer<Property.PropertyBuilder> init) {
            if (null == this.inputVariables) {
                this.inputVariables = new ArrayList<OperationVariable>();
            }
            this.inputVariables.add(this.createOperationVariable(idShort, type, init));
            return this;
        }

        public Operation.OperationBuilder addOutputVariable(String idShort, Type type, Consumer<Property.PropertyBuilder> init) {
            if (null == this.outputVariables) {
                this.outputVariables = new ArrayList<OperationVariable>();
            }
            this.outputVariables.add(this.createOperationVariable(idShort, type, init));
            return this;
        }

        public Operation.OperationBuilder addInOutVariable(String idShort, Type type, Consumer<Property.PropertyBuilder> init) {
            if (null == this.outputVariables) {
                this.outputVariables = new ArrayList<OperationVariable>();
            }
            this.inOutVariables.add(this.createOperationVariable(idShort, type, init));
            return this;
        }

        public Operation.OperationBuilder setInvocable(Invokable invocable) {
            if (invocable != null && !(invocable instanceof Serializable)) {
                throw new IllegalArgumentException("'invocable' for operation '" + this.operation.getIdShort() + "' must be Serializable.");
            }
            return this.setInvocableLazy(invocable);
        }

        public Operation.OperationBuilder setInvocableLazy(Invokable invocable) {
            if (null != invocable) {
                this.operation.setInvokable(invocable.getOperation());
            }
            return this;
        }

        public Operation.OperationBuilder setDescription(LangString ... description) {
            this.operation.setDescription(Tools.translate(description));
            return this;
        }

        public Operation build() {
            if (this.operation.getIdShort().contains("_")) {
                LoggerFactory.getLogger(BaSyxOperation.class).warn("IdShort of operation '{}' contains '_'. Invocation may fail.", (Object)this.operation.getIdShort());
            }
            if (null != this.inputVariables) {
                this.operation.setInputVariables(this.inputVariables);
            }
            if (null == this.outputVariables) {
                this.addOutputVariable("result", Type.NONE);
            }
            if (null != this.outputVariables) {
                this.operation.setOutputVariables(this.outputVariables);
            }
            if (null != this.inOutVariables) {
                this.operation.setInOutputVariables(this.inOutVariables);
            }
            this.instance.operation = this.operation;
            return this.parentBuilder.register(this.instance);
        }

        public Operation.OperationBuilder setSemanticId(String refValue) {
            IReference ref = Tools.translateReference(refValue);
            if (ref != null) {
                this.operation.setSemanticId(ref);
            }
            return this;
        }

        public Operation.OperationBuilder rbac(AuthenticationDescriptor auth, AuthenticationDescriptor.Role role, AuthenticationDescriptor.RbacAction ... actions) {
            return (Operation.OperationBuilder)AuthenticationDescriptor.elementRbac((Object)this, (AuthenticationDescriptor)auth, (AuthenticationDescriptor.Role)role, (String)this.parentBuilder.composeRbacPath(this.operation.getIdShort()), (AuthenticationDescriptor.RbacAction[])actions);
        }

        public Operation.OperationBuilder rbac(AuthenticationDescriptor auth) {
            return (Operation.OperationBuilder)AuthenticationDescriptor.parentRbac((Object)this, (AuthenticationDescriptor)auth, (Object[])this.parentBuilder.parents(), (String)this.parentBuilder.composeRbacPath(this.operation.getIdShort()), (AuthenticationDescriptor.RbacAction[])new AuthenticationDescriptor.RbacAction[]{AuthenticationDescriptor.RbacAction.READ, AuthenticationDescriptor.RbacAction.EXECUTE});
        }
    }
}

