/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx.security;

import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.basyx.security.AuthenticationDescriptorBasedAuthenticationManager;
import de.iip_ecosphere.platform.support.aas.basyx.security.FailNoAuthorizationFilter;
import de.iip_ecosphere.platform.support.logging.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.extensions.aas.aggregator.authorization.internal.AuthorizedAASAggregator;
import org.eclipse.basyx.extensions.aas.aggregator.authorization.internal.IAASAggregatorAuthorizer;
import org.eclipse.basyx.extensions.aas.aggregator.authorization.internal.SimpleRbacAASAggregatorAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.AuthenticationContextProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.PredefinedSetRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRule;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleSet;
import org.eclipse.basyx.extensions.shared.authorization.internal.TargetInformation;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;

public class Helper {
    private static final Map<AuthenticationDescriptor.RbacAction, String> ACTION_MAPPING = new HashMap<AuthenticationDescriptor.RbacAction, String>();

    public static String getDocBasePath(BaSyxContext context, Logger logger) {
        String docBasePath = null;
        try {
            Field fld = context.getClass().getDeclaredField("docBasePath");
            fld.setAccessible(true);
            docBasePath = (String)fld.get(context);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("Cannot find/access field docBasePath in BaSyxContext: " + e.getMessage());
        }
        return docBasePath;
    }

    public static Optional<JwtBearerTokenAuthenticationConfiguration> configureSecurity(BaSyxContext context, SetupSpec spec, SetupSpec.AasComponent component, Consumer<FilterChainProxy> filterChainConsumer) {
        SetupSpec.ComponentSetup setup = spec.getSetup(component);
        Optional<JwtBearerTokenAuthenticationConfiguration> jwtCfg = Optional.empty();
        AuthenticationDescriptor auth = setup.getAuthentication();
        if (AuthenticationDescriptor.isEnabledOnServer((AuthenticationDescriptor)auth) && SetupSpec.AasComponent.AAS_REPOSITORY == component) {
            if (auth.getServerUsers() != null) {
                AuthenticationDescriptorBasedAuthenticationManager authMgr = new AuthenticationDescriptorBasedAuthenticationManager(auth);
                ArrayList<Object> sortedListOfFilters = new ArrayList<Object>();
                sortedListOfFilters.add(new BasicAuthenticationFilter((AuthenticationManager)authMgr));
                Object uriExceptionRegEx = null;
                SetupSpec.ComponentSetup regSetup = spec.getSetup(SetupSpec.AasComponent.AAS_REGISTRY);
                if (regSetup.getEndpoint().toServerUri().equals(setup.getEndpoint().toServerUri())) {
                    uriExceptionRegEx = regSetup.getEndpoint().getEndpoint();
                    if (!((String)uriExceptionRegEx).startsWith("/")) {
                        uriExceptionRegEx = "/" + (String)uriExceptionRegEx;
                    }
                    if (!((String)uriExceptionRegEx).endsWith("/")) {
                        uriExceptionRegEx = (String)uriExceptionRegEx + "/";
                    }
                    uriExceptionRegEx = (String)uriExceptionRegEx + ".*";
                }
                sortedListOfFilters.add((Object)new FailNoAuthorizationFilter((String)uriExceptionRegEx, auth.requiresAnonymousAccess()));
                FilterChainProxy filterChainProxy = new FilterChainProxy((SecurityFilterChain)new DefaultSecurityFilterChain(AnyRequestMatcher.INSTANCE, sortedListOfFilters));
                filterChainConsumer.accept(filterChainProxy);
            } else if (auth.getOAuth2Setup() != null) {
                AuthenticationDescriptor.OAuth2Setup oauth2Setup = auth.getOAuth2Setup();
                jwtCfg = Optional.of(JwtBearerTokenAuthenticationConfiguration.of((String)oauth2Setup.getIssuerUri(), (String)oauth2Setup.getJwkSetUri(), (String)oauth2Setup.getRequiredAud()));
            }
        } else {
            jwtCfg = context.getJwtBearerTokenAuthenticationConfiguration();
        }
        return jwtCfg;
    }

    public static IAASAggregator addAuthorization(IAASAggregator aggregator, SetupSpec spec, SetupSpec.AasComponent component) {
        AuthenticationDescriptor auth;
        IAASAggregator result = aggregator;
        SetupSpec.ComponentSetup setup = spec.getSetup(component);
        if (null != setup && AuthenticationDescriptor.isEnabledOnServer((AuthenticationDescriptor)(auth = setup.getAuthentication())) && auth.getAccessRules() != null) {
            RbacRuleSet rbacSet = new RbacRuleSet();
            for (AuthenticationDescriptor.RbacRule r : auth.getAccessRules()) {
                for (AuthenticationDescriptor.RbacAction action : r.getActions()) {
                    String path = null;
                    if (r.getPath() != null) {
                        path = r.getPath().replaceAll(".", ".");
                    }
                    String aasId = null;
                    String smId = null;
                    if (r.getComponent() == AuthenticationDescriptor.RbacAasComponent.AAS) {
                        aasId = r.getElement();
                    } else if (r.getComponent() == AuthenticationDescriptor.RbacAasComponent.SUBMODEL || r.getComponent() == AuthenticationDescriptor.RbacAasComponent.SUBMODEL_ELEMENT) {
                        smId = r.getElement();
                    }
                    BaSyxObjectTargetInformation tInfo = new BaSyxObjectTargetInformation(aasId, smId, path);
                    rbacSet.addRule(new RbacRule(r.getRole().name(), ACTION_MAPPING.get(action), (TargetInformation)tInfo));
                }
            }
            result = new AuthorizedAASAggregator(result, (IAASAggregatorAuthorizer)new SimpleRbacAASAggregatorAuthorizer((IRbacRuleChecker)new PredefinedSetRbacRuleChecker(rbacSet), AuthenticationDescriptorBasedAuthenticationManager.AUTHENTICATOR), (ISubjectInformationProvider)new AuthenticationContextProvider());
        }
        return result;
    }

    static {
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.CREATE, AuthenticationDescriptor.RbacAction.CREATE.toString());
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.DELETE, AuthenticationDescriptor.RbacAction.DELETE.toString());
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.EXECUTE, AuthenticationDescriptor.RbacAction.EXECUTE.toString());
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.READ, AuthenticationDescriptor.RbacAction.READ.toString());
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.UPDATE, AuthenticationDescriptor.RbacAction.UPDATE.toString());
    }
}

