/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.registry.configuration.RegistryBackend;
import org.eclipse.basyx.components.registry.configuration.RegistryEventBackend;

public class BaSyxRegistryConfiguration
extends BaSyxConfiguration {
    public static final String ENV_PREFIX = "BaSyxRegistry_";
    private static final String FEATURE_ENABLED = "Enabled";
    private static final String FEATURE_DISABLED = "Disabled";
    public static final String DEFAULT_BACKEND = RegistryBackend.INMEMORY.toString();
    public static final String DEFAULT_EVENTS = RegistryEventBackend.NONE.toString();
    public static final String DEFAULT_AUTHORIZATION = "Disabled";
    public static final String DEFAULT_TAGGED_DIRECTORY = "Disabled";
    public static final String ID = "registry.id";
    public static final String BACKEND = "registry.backend";
    public static final String EVENTS = "registry.events";
    public static final String AUTHORIZATION = "registry.authorization";
    private static final String TAGGED_DIRECTORY = "registry.taggedDirectory";
    public static final String DEFAULT_CONFIG_PATH = "registry.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_REGISTRY";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(BACKEND, DEFAULT_BACKEND);
        defaultProps.put(EVENTS, DEFAULT_EVENTS);
        defaultProps.put(AUTHORIZATION, "Disabled");
        defaultProps.put(TAGGED_DIRECTORY, "Disabled");
        return defaultProps;
    }

    public BaSyxRegistryConfiguration() {
        super(BaSyxRegistryConfiguration.getDefaultProperties(), Collections.emptyList());
    }

    public BaSyxRegistryConfiguration(RegistryBackend backend) {
        super(BaSyxRegistryConfiguration.getDefaultProperties(), Collections.emptyList());
        this.setRegistryBackend(backend);
    }

    public BaSyxRegistryConfiguration(Map<String, String> values) {
        super(values, Collections.emptyList());
    }

    public void loadFromEnvironmentVariables() {
        this.loadFromEnvironmentVariables(ENV_PREFIX, new String[]{BACKEND, EVENTS, AUTHORIZATION, TAGGED_DIRECTORY, ID});
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
        this.loadFromEnvironmentVariables();
    }

    public String getRegistryId() {
        return this.getProperty(ID);
    }

    public RegistryBackend getRegistryBackend() {
        return RegistryBackend.fromString(this.getProperty(BACKEND));
    }

    public void setRegistryBackend(RegistryBackend backend) {
        this.setProperty(BACKEND, backend.toString());
    }

    public RegistryEventBackend getRegistryEvents() {
        return RegistryEventBackend.fromString(this.getProperty(EVENTS));
    }

    public void setRegistryEvents(RegistryEventBackend events) {
        this.setProperty(EVENTS, events.toString());
    }

    public boolean isAuthorizationEnabled() {
        return this.getProperty(AUTHORIZATION).equals(FEATURE_ENABLED);
    }

    public void enableAuthorization() {
        this.setProperty(AUTHORIZATION, FEATURE_ENABLED);
    }

    public void disableAuthorization() {
        this.setProperty(AUTHORIZATION, "Disabled");
    }

    public boolean isTaggedDirectoryEnabled() {
        return this.getProperty(TAGGED_DIRECTORY).equals(FEATURE_ENABLED);
    }

    public void enableTaggedDirectory() {
        this.setProperty(TAGGED_DIRECTORY, FEATURE_ENABLED);
    }

    public void disableTaggedDirectory() {
        this.setProperty(TAGGED_DIRECTORY, "Disabled");
    }
}

