/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.ByteBufBsonHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.bson.BsonArray;
import org.bson.BsonBinaryReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.io.BsonInput;
import org.bson.io.ByteBufferBsonInput;

final class ByteBufBsonArray
extends BsonArray {
    private final ByteBuf byteBuf;
    private static final String READ_ONLY_MESSAGE = "This BsonArray instance is read-only";

    ByteBufBsonArray(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public Iterator<BsonValue> iterator() {
        return new ByteBufBsonArrayIterator();
    }

    public List<BsonValue> getValues() {
        ArrayList<BsonValue> values = new ArrayList<BsonValue>();
        Iterator<BsonValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            BsonValue cur = iterator.next();
            values.add(cur);
        }
        return values;
    }

    public int size() {
        int size = 0;
        Iterator<BsonValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            BsonValue ignored = iterator.next();
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        Iterator<BsonValue> e1 = this.iterator();
        Iterator e2 = ((List)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            if (Objects.equals(e1.next(), e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator<BsonValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            BsonValue cur = iterator.next();
            hashCode = 31 * hashCode + (cur == null ? 0 : cur.hashCode());
        }
        return hashCode;
    }

    public boolean contains(Object o) {
        Iterator<BsonValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            BsonValue cur = iterator.next();
            if (!Objects.equals(o, cur)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray() {
        Object[] retVal = new Object[this.size()];
        Iterator<BsonValue> it = this.iterator();
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = it.next();
        }
        return retVal;
    }

    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] retVal = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        Iterator<BsonValue> it = this.iterator();
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = it.next();
        }
        return retVal;
    }

    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public BsonValue get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        int i = 0;
        Iterator<BsonValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            BsonValue cur = iterator.next();
            if (i++ != index) continue;
            return cur;
        }
        throw new IndexOutOfBoundsException("Index out of range: " + index);
    }

    public int indexOf(Object o) {
        int i = 0;
        Iterator<BsonValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            BsonValue cur = iterator.next();
            if (Objects.equals(o, cur)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        ListIterator<BsonValue> listIterator = this.listIterator(this.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equals(o, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    public ListIterator<BsonValue> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<BsonValue> listIterator(int index) {
        return new ArrayList(this).listIterator(index);
    }

    public List<BsonValue> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        ArrayList<BsonValue> subList = new ArrayList<BsonValue>();
        int i = 0;
        Iterator<BsonValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            BsonValue cur = iterator.next();
            if (i == toIndex) break;
            if (i >= fromIndex) {
                subList.add(cur);
            }
            ++i;
        }
        if (toIndex > i) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        return subList;
    }

    public boolean add(BsonValue bsonValue) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public boolean addAll(Collection<? extends BsonValue> c) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public boolean addAll(int index, Collection<? extends BsonValue> c) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public void clear() {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public BsonValue set(int index, BsonValue element) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public void add(int index, BsonValue element) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public BsonValue remove(int index) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    private class ByteBufBsonArrayIterator
    implements Iterator<BsonValue> {
        private final ByteBuf duplicatedByteBuf;
        private final BsonBinaryReader bsonReader;

        private ByteBufBsonArrayIterator() {
            this.duplicatedByteBuf = ByteBufBsonArray.this.byteBuf.duplicate();
            this.bsonReader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(this.duplicatedByteBuf));
            this.bsonReader.readStartDocument();
            this.bsonReader.readBsonType();
        }

        @Override
        public boolean hasNext() {
            return this.bsonReader.getCurrentBsonType() != BsonType.END_OF_DOCUMENT;
        }

        @Override
        public BsonValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.bsonReader.skipName();
            BsonValue value = ByteBufBsonHelper.readBsonValue(this.duplicatedByteBuf, this.bsonReader);
            this.bsonReader.readBsonType();
            return value;
        }
    }
}

