/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaSyxConfiguration {
    private static Logger logger = LoggerFactory.getLogger(BaSyxConfiguration.class);
    private Map<String, String> values;
    private List<String> propertiesExcludedFromLogging;

    @Deprecated
    public BaSyxConfiguration(Map<String, String> defaultValues) {
        this.values = defaultValues;
    }

    public BaSyxConfiguration(Map<String, String> defaultValues, List<String> propertiesExcludedFromLogging) {
        this(defaultValues);
        this.propertiesExcludedFromLogging = propertiesExcludedFromLogging;
    }

    public static InputStream getResourceStream(String relativeResourcePath) {
        ClassLoader classLoader = BaSyxConfiguration.class.getClassLoader();
        return classLoader.getResourceAsStream(relativeResourcePath);
    }

    public static String getResourceString(String relativeResourcePath) throws IOException {
        ClassLoader classLoader = BaSyxConfiguration.class.getClassLoader();
        return IOUtils.resourceToString((String)relativeResourcePath, (Charset)StandardCharsets.UTF_8, (ClassLoader)classLoader);
    }

    public void loadFromFile(String filePath) {
        try (FileInputStream fileStream = new FileInputStream(filePath);){
            logger.info("Loading properties from file '" + filePath + "'");
            this.loadFromStream(fileStream);
        }
        catch (FileNotFoundException e) {
            logger.error("Configuration file not found: '" + filePath + "'", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Configuration io error: '" + filePath + "'", (Throwable)e);
        }
    }

    public void loadFileOrDefaultResource(String fileKey, String defaultResource) {
        String configFilePath = System.getProperty(fileKey);
        if (configFilePath == null || configFilePath.isEmpty()) {
            configFilePath = System.getenv(fileKey);
        }
        if (configFilePath != null && !configFilePath.isEmpty()) {
            this.loadFromFile(configFilePath);
        } else {
            this.loadFromResource(defaultResource);
        }
    }

    public void loadFromStream(InputStream input) {
        logger.info("Loading from inputStream: " + input);
        Properties properties = new Properties();
        try {
            properties.load(input);
            this.loadFromProperties(properties);
        }
        catch (IOException e) {
            logger.error("Could not load properties", (Throwable)e);
        }
    }

    public void loadFromResource(String relativeResourcePath) {
        logger.info("Loading properties from resource '" + relativeResourcePath + "'");
        try (InputStream resourceStream = BaSyxConfiguration.getResourceStream(relativeResourcePath);){
            if (resourceStream == null) {
                logger.info("Could not get resource stream!");
            }
            this.loadFromStream(resourceStream);
        }
        catch (FileNotFoundException e) {
            logger.error("Configuration resource not found: '" + relativeResourcePath + "'", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Configuration io error: '" + relativeResourcePath + "'", (Throwable)e);
        }
    }

    public void loadFromProperties(Properties properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            String loaded = properties.getProperty(propertyName);
            this.logPropertyVariable(propertyName, loaded);
            this.values.put(propertyName, loaded);
        }
    }

    protected void loadFromEnvironmentVariables(String prefix, String ... properties) {
        try {
            Map<String, String> allEnvironmentVariables = System.getenv();
            boolean usesLowerCaseNamingConvention = this.usesLowerCaseNamingConvention(allEnvironmentVariables, prefix);
            boolean usesDeprecatedNamingConvention = this.usesDeprecatedNamingConvention(allEnvironmentVariables, prefix);
            if (usesDeprecatedNamingConvention && usesLowerCaseNamingConvention) {
                throw this.createEnvironmentVariableWrongUsageException();
            }
            for (String propName : properties) {
                String result = this.getEnvironmentVariable(prefix, propName, usesDeprecatedNamingConvention);
                if (result == null) continue;
                this.logEnvironmentVariable(propName, result);
                this.setProperty(propName, result);
            }
        }
        catch (SecurityException e) {
            logger.info("Reading configs from environment is not permitted: " + e);
        }
    }

    private void logPropertyVariable(String propertyName, String result) {
        if (this.isPropertyExcludedFromLogging(propertyName)) {
            result = "*****";
        }
        logger.info("Property File - " + propertyName + ": '" + result + "'");
    }

    private void logEnvironmentVariable(String propertyName, String result) {
        if (this.isPropertyExcludedFromLogging(propertyName)) {
            result = "*****";
        }
        logger.info("Environment - " + propertyName + ": " + result);
    }

    private boolean isPropertyExcludedFromLogging(String propertyName) {
        return this.propertiesExcludedFromLogging.contains(propertyName);
    }

    private String getEnvironmentVariable(String prefix, String propName, boolean usesDeprecatedNamingConvention) {
        if (usesDeprecatedNamingConvention) {
            return this.getEnvironmentVariableDeprecatedNamingConvention(prefix, propName);
        }
        return this.getEnvironmentVariableLowerCaseNamingConvention(prefix, propName);
    }

    private String getEnvironmentVariableLowerCaseNamingConvention(String prefix, String propName) {
        return System.getenv(this.changeToUnderscoreAndLowerCase(prefix + propName));
    }

    private String getEnvironmentVariableDeprecatedNamingConvention(String prefix, String propName) {
        return System.getenv(prefix + propName);
    }

    private boolean usesLowerCaseNamingConvention(Map<String, String> allEnvironmentVariables, String prefix) {
        List<String> variableWithLowercasePrefix = this.getEnvironmentVariablesLowerCaseNamingConvention(allEnvironmentVariables, prefix);
        if (this.containsUpperCasePrefixVariables(variableWithLowercasePrefix)) {
            throw this.createEnvironmentVariableWrongUsageException();
        }
        return !variableWithLowercasePrefix.isEmpty();
    }

    private boolean containsUpperCasePrefixVariables(List<String> variableWithLowercasePrefix) {
        return variableWithLowercasePrefix.stream().anyMatch(varName -> this.nameContainsUppercase((String)varName));
    }

    private boolean usesDeprecatedNamingConvention(Map<String, String> allEnvironmentVariables, String prefix) {
        List<String> variableWithPrefix = this.getEnvironmentVariablesDeprecatedNamingConvention(allEnvironmentVariables, prefix);
        if (this.containsDotAndUnderscoreInDeprecatedNamingConvention(variableWithPrefix, prefix)) {
            throw this.createEnvironmentVariableWrongUsageException();
        }
        return !variableWithPrefix.isEmpty();
    }

    private boolean containsDotAndUnderscoreInDeprecatedNamingConvention(List<String> variableWithLowercasePrefix, String prefix) {
        return variableWithLowercasePrefix.stream().anyMatch(varName -> this.nameWihoutPrefixContainsUnderscore((String)varName, prefix));
    }

    private boolean nameWihoutPrefixContainsUnderscore(String varName, String prefix) {
        return varName.replace(prefix, "").contains("_");
    }

    private List<String> getEnvironmentVariablesLowerCaseNamingConvention(Map<String, String> allEnvironmentVariables, String prefix) {
        return allEnvironmentVariables.keySet().stream().filter(x -> x.startsWith(this.changeToUnderscoreAndLowerCase(prefix))).collect(Collectors.toList());
    }

    private List<String> getEnvironmentVariablesDeprecatedNamingConvention(Map<String, String> allEnvironmentVariables, String prefix) {
        return allEnvironmentVariables.keySet().stream().filter(x -> x.startsWith(prefix)).collect(Collectors.toList());
    }

    private RuntimeException createEnvironmentVariableWrongUsageException() {
        return new RuntimeException("BaSyx environment variables should either use '.' or '_' as the separator, not both at the same time.");
    }

    private boolean nameContainsUppercase(String varName) {
        return varName.chars().anyMatch(c -> Character.isUpperCase(c));
    }

    private String changeToUnderscoreAndLowerCase(String variableName) {
        return variableName.toLowerCase().replace('.', '_');
    }

    public void setProperty(String name, String value) {
        this.values.put(name, value);
    }

    public List<String> getProperties(String prefix) {
        return this.values.keySet().stream().filter(key -> key.startsWith(prefix)).collect(Collectors.toList());
    }

    public String getProperty(String name) {
        return this.values.get(name);
    }
}

