/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.models.controlcomponent;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.basyx.models.controlcomponent.ControlComponentChangeListener;
import org.eclipse.basyx.models.controlcomponent.ExecutionMode;
import org.eclipse.basyx.models.controlcomponent.ExecutionOrder;
import org.eclipse.basyx.models.controlcomponent.ExecutionState;
import org.eclipse.basyx.models.controlcomponent.OccupationState;

public abstract class ControlComponent
extends HashMap<String, Object> {
    public static final String STATUS = "STATUS";
    public static final String OPERATIONS = "OPERATIONS";
    public static final String OPERATION_CLEAR = "CLEAR";
    public static final String OPERATION_STOP = "STOP";
    public static final String OPERATION_ABORT = "ABORT";
    public static final String OPERATION_RESET = "RESET";
    public static final String OPERATION_START = "START";
    public static final String OPERATION_MANUAL = "MANUAL";
    public static final String OPERATION_AUTO = "AUTO";
    public static final String OPERATION_PRIORITY = "PRIO";
    public static final String OPERATION_OCCUPY = "OCCUPY";
    public static final String OPERATION_FREE = "FREE";
    public static final String CMD = "cmd";
    public static final String ERROR_STATE = "ER";
    public static final String WORK_STATE = "WORKST";
    public static final String OP_MODE = "OPMODE";
    public static final String EX_STATE = "EXST";
    public static final String EX_MODE = "EXMODE";
    public static final String OCCUPIER = "OCCUPIER";
    public static final String OCCUPATION_STATE = "OCCST";
    private static final long serialVersionUID = 1L;
    protected Map<String, Function<?, ?>> operations = new HashMap();
    protected String savedOccupierID = null;
    protected Map<String, Object> status = null;
    protected Collection<ControlComponentChangeListener> listeners = new LinkedList<ControlComponentChangeListener>();

    public ControlComponent() {
        this.status = new StatusMap();
        this.put(STATUS, (Object)this.status);
        this.put(CMD, (Object)"");
        this.put(OPERATIONS, (Object)this.operations);
        this.operations.put(OPERATION_FREE, (Function<Object[], Void> & Serializable)v -> {
            this.freeControlComponent((String)v[0]);
            return null;
        });
        this.operations.put(OPERATION_OCCUPY, (Function<Object[], Void> & Serializable)v -> {
            this.occupyControlComponent((String)v[0]);
            return null;
        });
        this.operations.put(OPERATION_PRIORITY, (Function<Object[], Void> & Serializable)v -> {
            this.priorityOccupation((String)v[0]);
            return null;
        });
        this.operations.put(OPERATION_AUTO, (Function<Object, Void> & Serializable)v -> {
            this.setExecutionMode(ExecutionMode.AUTO);
            return null;
        });
        this.operations.put(OPERATION_MANUAL, (Function<Object, Void> & Serializable)v -> {
            this.setExecutionMode(ExecutionMode.MANUAL);
            return null;
        });
        this.operations.put(OPERATION_START, (Function<Object, Void> & Serializable)v -> {
            this.changeExecutionState(ExecutionOrder.START.getValue());
            return null;
        });
        this.operations.put(OPERATION_RESET, (Function<Object, Void> & Serializable)v -> {
            this.changeExecutionState(ExecutionOrder.RESET.getValue());
            return null;
        });
        this.operations.put(OPERATION_ABORT, (Function<Object, Void> & Serializable)v -> {
            this.changeExecutionState(ExecutionOrder.ABORT.getValue());
            return null;
        });
        this.operations.put(OPERATION_STOP, (Function<Object, Void> & Serializable)v -> {
            this.changeExecutionState(ExecutionOrder.STOP.getValue());
            return null;
        });
        this.operations.put(OPERATION_CLEAR, (Function<Object, Void> & Serializable)v -> {
            this.changeExecutionState(ExecutionOrder.CLEAR.getValue());
            return null;
        });
    }

    protected String filterExecutionState(String exState) {
        return exState;
    }

    protected String filterOperationMode(String opMode) {
        return opMode;
    }

    public void addControlComponentChangeListener(ControlComponentChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeControlComponentChangeListener(ControlComponentChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Object put(String key, Object value) {
        Object result = super.put(key, value);
        for (ControlComponentChangeListener listener : this.listeners) {
            listener.onVariableChange(key, value);
        }
        switch (key) {
            case "cmd": {
                this.changeExecutionState(value.toString());
            }
        }
        return result;
    }

    private void freeControlComponent(String senderId) {
        if (senderId.equals(this.getOccupierID())) {
            if (this.getOccupierID().isEmpty()) {
                this.setOccupationState(OccupationState.FREE);
            } else {
                this.setOccupationState(OccupationState.OCCUPIED);
            }
        }
    }

    private void occupyControlComponent(String occupier) {
        if (this.getOccupationState().equals((Object)OccupationState.FREE)) {
            this.setOccupierID(occupier);
            this.setOccupationState(OccupationState.OCCUPIED);
        }
    }

    private void priorityOccupation(String occupier) {
        if (this.getOccupationState().equals((Object)OccupationState.FREE) || this.getOccupationState().equals((Object)OccupationState.OCCUPIED)) {
            this.setOccupierID(occupier);
            this.setOccupationState(OccupationState.PRIORITY);
        }
    }

    private void changeExecutionState(String orderString) {
        if (orderString.isEmpty()) {
            return;
        }
        ExecutionOrder order = ExecutionOrder.byValue(orderString);
        switch (ExecutionState.byValue(this.getExecutionState())) {
            case IDLE: {
                if (order.equals((Object)ExecutionOrder.START)) {
                    this.setExecutionState(ExecutionState.STARTING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case STARTING: {
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case EXECUTE: {
                if (order.equals((Object)ExecutionOrder.COMPLETE)) {
                    this.setExecutionState(ExecutionState.COMPLETING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.HOLD)) {
                    this.setExecutionState(ExecutionState.HOLDING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.SUSPEND)) {
                    this.setExecutionState(ExecutionState.SUSPENDING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case COMPLETING: {
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case COMPLETE: {
                if (order.equals((Object)ExecutionOrder.RESET)) {
                    this.setExecutionState(ExecutionState.RESETTING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case RESETTING: {
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case HOLDING: {
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case HELD: {
                if (order.equals((Object)ExecutionOrder.UNHOLD)) {
                    this.setExecutionState(ExecutionState.UNHOLDING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case UNHOLDING: {
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case SUSPENDING: {
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case SUSPENDED: {
                if (order.equals((Object)ExecutionOrder.UNSUSPEND)) {
                    this.setExecutionState(ExecutionState.UNSUSPENDING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case UNSUSPENDING: {
                if (order.equals((Object)ExecutionOrder.STOP)) {
                    this.setExecutionState(ExecutionState.STOPPING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case STOPPING: {
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case STOPPED: {
                if (order.equals((Object)ExecutionOrder.RESET)) {
                    this.setExecutionState(ExecutionState.RESETTING.getValue());
                    break;
                }
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case ABORTED: {
                if (order.equals((Object)ExecutionOrder.CLEAR)) {
                    this.setExecutionState(ExecutionState.CLEARING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            case CLEARING: {
                if (order.equals((Object)ExecutionOrder.ABORT)) {
                    this.setExecutionState(ExecutionState.ABORTING.getValue());
                    break;
                }
                throw new RuntimeException("Unexpected command " + orderString + " in state " + this.getExecutionState());
            }
            default: {
                throw new RuntimeException("Unexpected order " + orderString + " in state " + this.getExecutionState());
            }
        }
    }

    public void finishState() {
        switch (ExecutionState.byValue(this.getExecutionState())) {
            case STARTING: {
                this.setExecutionState(ExecutionState.EXECUTE.getValue());
                break;
            }
            case EXECUTE: {
                this.setExecutionState(ExecutionState.COMPLETING.getValue());
                break;
            }
            case COMPLETING: {
                this.setExecutionState(ExecutionState.COMPLETE.getValue());
                break;
            }
            case RESETTING: {
                this.setExecutionState(ExecutionState.IDLE.getValue());
                break;
            }
            case HOLDING: {
                this.setExecutionState(ExecutionState.HELD.getValue());
                break;
            }
            case UNHOLDING: {
                this.setExecutionState(ExecutionState.EXECUTE.getValue());
                break;
            }
            case SUSPENDING: {
                this.setExecutionState(ExecutionState.SUSPENDED.getValue());
                break;
            }
            case UNSUSPENDING: {
                this.setExecutionState(ExecutionState.EXECUTE.getValue());
                break;
            }
            case STOPPING: {
                this.setExecutionState(ExecutionState.STOPPED.getValue());
                break;
            }
            case STOPPED: {
                this.setExecutionState(ExecutionState.IDLE.getValue());
                break;
            }
            case ABORTING: {
                this.setExecutionState(ExecutionState.ABORTED.getValue());
                break;
            }
            case CLEARING: {
                this.setExecutionState(ExecutionState.STOPPED.getValue());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected state complete order in state " + this.getExecutionState());
            }
        }
    }

    public OccupationState getOccupationState() {
        return OccupationState.byValue((Integer)this.status.get(OCCUPATION_STATE));
    }

    public void setOccupationState(OccupationState occSt) {
        this.status.put(OCCUPATION_STATE, occSt.getValue());
    }

    public String getOccupierID() {
        try {
            return this.status.get(OCCUPIER).toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public void setOccupierID(String occId) {
        this.status.put(OCCUPIER, occId);
    }

    public ExecutionMode getExecutionMode() {
        return ExecutionMode.byValue((Integer)this.status.get(EX_MODE));
    }

    public void setExecutionMode(ExecutionMode exMode) {
        this.status.put(EX_MODE, exMode.getValue());
    }

    public String getExecutionState() {
        try {
            return this.status.get(EX_STATE).toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public void setExecutionState(String newSt) {
        this.status.put(EX_STATE, newSt);
    }

    public String getOperationMode() {
        try {
            return this.status.get(OP_MODE).toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public void setOperationMode(String opMode) {
        this.status.put(OP_MODE, opMode);
    }

    public String getWorkState() {
        try {
            return this.status.get(WORK_STATE).toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public void setWorkState(String workState) {
        this.status.put(WORK_STATE, workState);
    }

    public String getErrorState() {
        try {
            return this.status.get(ERROR_STATE).toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public void setErrorState(String errorState) {
        this.status.put(ERROR_STATE, errorState);
    }

    public String getCommand() {
        try {
            return this.get(CMD).toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public void setCommand(String cmd) {
        this.put(CMD, (Object)cmd);
    }

    class StatusMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        public StatusMap() {
            this.put(ControlComponent.OCCUPATION_STATE, (Object)OccupationState.FREE.getValue());
            this.put(ControlComponent.OCCUPIER, (Object)"");
            this.put(ControlComponent.EX_MODE, (Object)ExecutionMode.AUTO.getValue());
            this.put(ControlComponent.EX_STATE, (Object)ExecutionState.IDLE.getValue());
            this.put(ControlComponent.OP_MODE, (Object)"");
            this.put(ControlComponent.WORK_STATE, (Object)"");
            this.put(ControlComponent.ERROR_STATE, (Object)"");
        }

        @Override
        public Object put(String key, Object parValue) {
            Object value = parValue;
            switch (key) {
                case "EXST": {
                    value = ControlComponent.this.filterExecutionState(value.toString());
                    break;
                }
                case "OPMODE": {
                    value = ControlComponent.this.filterOperationMode(value.toString());
                }
            }
            Object result = super.put(key, value);
            for (ControlComponentChangeListener listener : ControlComponent.this.listeners) {
                listener.onVariableChange(key, value);
            }
            switch (key) {
                case "OCCST": {
                    for (ControlComponentChangeListener listener : ControlComponent.this.listeners) {
                        listener.onNewOccupationState(OccupationState.byValue((Integer)value));
                    }
                    break;
                }
                case "OCCUPIER": {
                    for (ControlComponentChangeListener listener : ControlComponent.this.listeners) {
                        listener.onNewOccupier(value.toString());
                    }
                    break;
                }
                case "EXMODE": {
                    for (ControlComponentChangeListener listener : ControlComponent.this.listeners) {
                        listener.onChangedExecutionMode(ExecutionMode.byValue((Integer)value));
                    }
                    break;
                }
                case "EXST": {
                    for (ControlComponentChangeListener listener : ControlComponent.this.listeners) {
                        listener.onChangedExecutionState(ExecutionState.byValue(value.toString()));
                    }
                    break;
                }
                case "OPMODE": {
                    for (ControlComponentChangeListener listener : ControlComponent.this.listeners) {
                        listener.onChangedOperationMode(value.toString());
                    }
                    break;
                }
                case "WORKST": {
                    for (ControlComponentChangeListener listener : ControlComponent.this.listeners) {
                        listener.onChangedWorkState(value.toString());
                    }
                    break;
                }
                case "ER": {
                    for (ControlComponentChangeListener listener : ControlComponent.this.listeners) {
                        listener.onChangedErrorState(value.toString());
                    }
                    break;
                }
            }
            return result;
        }
    }
}

