/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx1_5;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAbstractAasServer;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistry;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.aas.basyx.VersionAdjustment;
import de.iip_ecosphere.platform.support.aas.basyx1_5.BaSyxRegistryDeploymentAasServer;
import de.iip_ecosphere.platform.support.aas.basyx1_5.basyx.BaSyxHTTPServer;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IBaSyxConnector;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.IAuthorizationSupplier;
import org.eclipse.basyx.vab.protocol.https.HTTPSConnectorProvider;

public class BaSyxAasFactory
extends de.iip_ecosphere.platform.support.aas.basyx.BaSyxAasFactory {
    private static final String PLUGIN_ID = "aas.basyx-1.5";

    public BaSyxAasFactory() {
        Tools.mapBaSyxType((Type)Type.DOUBLE, (ValueType)ValueType.Decimal);
        Tools.mapBaSyxType((Type)Type.DATE_TIME, (ValueType)ValueType.Date);
        VersionAdjustment.setupBaSyxServerCreator((VersionAdjustment.ServerCreator)new VersionAdjustment.ServerCreator(){

            public Server createServer(DeploymentSpec dSpec, SetupSpec sSpec, SetupSpec.AasComponent component) {
                final BaSyxHTTPServer server = new BaSyxHTTPServer(dSpec.getContext(), sSpec, component);
                Server result = new Server(){

                    public Server start() {
                        server.start();
                        return this;
                    }

                    public void stop(boolean dispose) {
                        server.shutdown();
                    }
                };
                return result;
            }
        });
        VersionAdjustment.setupRegistryDeploymentServerCreator((VersionAdjustment.RegistryDeploymentServerCreator)new VersionAdjustment.RegistryDeploymentServerCreator(){

            public BaSyxAbstractAasServer createRegistryDeploymentServer(DeploymentSpec deploymentSpec, SetupSpec spec, SetupSpec.AasComponent component, String regUrl, AASServerBackend backend, String ... options) {
                return new BaSyxRegistryDeploymentAasServer(deploymentSpec, spec, component, regUrl, backend, options);
            }
        });
    }

    public String getName() {
        return "AAS/BaSyx v1.5.1 (2024/05/02)";
    }

    public boolean supportsPropertyFunctions() {
        return true;
    }

    public Registry obtainRegistry(SetupSpec spec, Schema aasSchema) throws IOException {
        SetupSpec.ComponentSetup cSetup = spec.getSetup(SetupSpec.AasComponent.AAS_REGISTRY);
        final AuthenticationDescriptor aDesc = cSetup.getAuthentication();
        final IAuthorizationSupplier authSupplier = new IAuthorizationSupplier(){

            public Optional<String> getAuthorization() {
                String header = null;
                if (AuthenticationDescriptor.isEnabledOnClient((AuthenticationDescriptor)aDesc)) {
                    header = AuthenticationDescriptor.authenticate((AuthenticationDescriptor)aDesc, (boolean)false);
                }
                return header == null ? Optional.empty() : Optional.of(header);
            }
        };
        Object cFactory = Schema.HTTPS == aasSchema ? new HTTPSConnectorProvider(authSupplier) : new HTTPConnectorFactory(){

            protected IModelProvider createProvider(String addr) {
                return new JSONConnector((IBaSyxConnector)new HTTPConnector(addr, authSupplier));
            }
        };
        return new BaSyxRegistry(cSetup.getEndpoint(), (IConnectorFactory)cFactory);
    }

    public static class Descriptor
    extends AasFactory.AbstractDescriptor {
        public AasFactory createInstance() {
            return new BaSyxAasFactory();
        }

        public String getId() {
            return BaSyxAasFactory.PLUGIN_ID;
        }
    }
}

