/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.aas.active;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.basyx.tools.aas.active.VABModelTask;
import org.eclipse.basyx.tools.aas.active.VABModelTaskGroup;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class ActiveModel {
    private Set<VABModelTaskGroup> groups = new HashSet<VABModelTaskGroup>();
    private IModelProvider modelProvider;

    public ActiveModel(IModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    public VABModelTaskGroup runTask(int updateInterval, VABModelTask task) {
        VABModelTaskGroup group = new VABModelTaskGroup(this.modelProvider);
        this.groups.add(group);
        group.setUpdateInterval(updateInterval).addTask(task).start();
        return group;
    }

    public VABModelTaskGroup createTaskGroup() {
        VABModelTaskGroup group = new VABModelTaskGroup(this.modelProvider);
        this.groups.add(group);
        return group;
    }

    public void clear() {
        for (VABModelTaskGroup group : this.groups) {
            group.clear();
        }
        this.groups.clear();
    }

    public Set<VABModelTaskGroup> getTaskGroups() {
        return this.groups;
    }

    public void stopAll() {
        for (VABModelTaskGroup group : this.groups) {
            group.stop();
        }
    }

    public void startAll() {
        for (VABModelTaskGroup group : this.groups) {
            group.start();
        }
    }
}

