/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.aascomponent;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.List;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregatorFactory;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.components.aas.aascomponent.AbstractAASServerComponentFactory;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.components.aas.mongodb.MongoDBAASAPIFactory;
import org.eclipse.basyx.components.aas.mongodb.MongoDBAASAggregatorFactory;
import org.eclipse.basyx.components.aas.mongodb.MongoDBSubmodelAPIFactory;
import org.eclipse.basyx.components.aas.mongodb.MongoDBSubmodelAggregatorFactory;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;

public class MongoDBAASServerComponentFactory
extends AbstractAASServerComponentFactory {
    private BaSyxMongoDBConfiguration mongoDBConfig;
    private MongoClient client;

    public MongoDBAASServerComponentFactory(BaSyxMongoDBConfiguration config, List<IAASServerDecorator> decorators, IAASRegistry aasServerRegistry) {
        this.mongoDBConfig = config;
        this.aasServerRegistry = aasServerRegistry;
        this.aasServerDecorators = decorators;
        this.client = MongoClients.create((String)config.getConnectionUrl());
    }

    public MongoDBAASServerComponentFactory(BaSyxMongoDBConfiguration config, IAASRegistry aasServerRegistry) {
        this.mongoDBConfig = config;
        this.aasServerRegistry = aasServerRegistry;
        this.client = MongoClients.create((String)config.getConnectionUrl());
    }

    @Override
    protected ISubmodelAPIFactory createSubmodelAPIFactory() {
        return new MongoDBSubmodelAPIFactory(this.mongoDBConfig, this.client);
    }

    @Override
    protected ISubmodelAggregatorFactory createSubmodelAggregatorFactory(ISubmodelAPIFactory submodelAPIFactory) {
        return new MongoDBSubmodelAggregatorFactory(this.mongoDBConfig, submodelAPIFactory, this.client);
    }

    @Override
    protected IAASAPIFactory createAASAPIFactory() {
        return new MongoDBAASAPIFactory(this.mongoDBConfig, this.client);
    }

    @Override
    protected IAASAggregatorFactory createAASAggregatorFactory(IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        return new MongoDBAASAggregatorFactory(this.mongoDBConfig, this.aasServerRegistry, aasAPIFactory, submodelAggregatorFactory, this.client);
    }
}

