/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAbstractAasServer;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistryDeploymentAasServer;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.aas.configuration.BaSyxAASServerConfiguration;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.haskind.ModelingKind;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxHTTPServer;

public class VersionAdjustment {
    public static final ServerCreator DEFAULT_SERVER_CREATOR = new ServerCreator(){

        @Override
        public Server createServer(DeploymentSpec spec, SetupSpec sSpec, SetupSpec.AasComponent component) {
            final BaSyxHTTPServer server = new BaSyxHTTPServer(spec.getContext());
            Server result = new Server(){

                public Server start() {
                    server.start();
                    return this;
                }

                public void stop(boolean dispose) {
                    server.shutdown();
                }
            };
            return result;
        }
    };
    public static final RegistryDeploymentServerCreator DEFAULT_DEPLOYMENT_SERVER_CREATOR = new RegistryDeploymentServerCreator(){

        @Override
        public BaSyxAbstractAasServer createRegistryDeploymentServer(DeploymentSpec deploymentSpec, SetupSpec spec, SetupSpec.AasComponent component, String regUrl, AASServerBackend backend, String ... options) {
            return new BaSyxRegistryDeploymentAasServer(deploymentSpec, spec, component, regUrl, backend, options);
        }
    };
    private static Map<Class<?>, SetPropertyKind> setPropertyKind = new HashMap();
    private static Map<Class<?>, OperationInvoke> invokeOperation = new HashMap();
    private static Map<Class<?>, SetBearerTokenAuthenticationConfiguration> setBearerAuthenticationTokenConf = new HashMap();
    private static Map<Class<?>, SetupBaSyxAASServerConfiguration> setupBaSyxAASServerConfiguration = new HashMap();
    private static ServerCreator serverCreator = DEFAULT_SERVER_CREATOR;
    private static RegistryDeploymentServerCreator deploymentServerCreator = DEFAULT_DEPLOYMENT_SERVER_CREATOR;

    public static void registerSetPropertyKind(Class<? extends Property> property, SetPropertyKind setter) {
        setPropertyKind.put(property, setter);
    }

    public static void setPropertyKind(Property property, ModelingKind kind) {
        setPropertyKind.get(property.getClass()).set(property, kind);
    }

    public static void registerOperationInvoke(Class<? extends IOperation> operation, OperationInvoke invoker) {
        invokeOperation.put(operation, invoker);
    }

    public static Object operationInvoke(IOperation operation, Object[] args) {
        return invokeOperation.get(operation.getClass()).invoke(operation, args);
    }

    public static void registerSetBearerTokenAuthenticationConfiguration(Class<? extends BaSyxContext> context, SetBearerTokenAuthenticationConfiguration setter) {
        setBearerAuthenticationTokenConf.put(context, setter);
    }

    public static void setBearerTokenAuthenticationConfiguration(BaSyxContext context, String issuerUri, String jwkSetUri, String requiredAud) {
        setBearerAuthenticationTokenConf.get(context.getClass()).set(context, issuerUri, jwkSetUri, requiredAud);
    }

    public static void registerSetupBaSyxAASServerConfiguration(Class<? extends BaSyxAASServerConfiguration> config, SetupBaSyxAASServerConfiguration initializer) {
        setupBaSyxAASServerConfiguration.put(config, initializer);
    }

    public static void setupBaSyxAASServerConfiguration(BaSyxAASServerConfiguration cfg) {
        setupBaSyxAASServerConfiguration.get(cfg.getClass()).setup(cfg);
    }

    public static Server createBaSyxServer(DeploymentSpec dSpec, SetupSpec sSpec, SetupSpec.AasComponent component) {
        return serverCreator.createServer(dSpec, sSpec, component);
    }

    public static void setupBaSyxServerCreator(ServerCreator creator) {
        if (null != creator) {
            serverCreator = creator;
        }
    }

    public static BaSyxAbstractAasServer createRegistryDeploymentServer(DeploymentSpec deploymentSpec, SetupSpec spec, SetupSpec.AasComponent component, String regUrl, AASServerBackend backend, String ... options) {
        return deploymentServerCreator.createRegistryDeploymentServer(deploymentSpec, spec, component, regUrl, backend, options);
    }

    public static void setupRegistryDeploymentServerCreator(RegistryDeploymentServerCreator creator) {
        if (null != creator) {
            deploymentServerCreator = creator;
        }
    }

    public static interface SetPropertyKind {
        public void set(Property var1, ModelingKind var2);
    }

    public static interface OperationInvoke {
        public Object invoke(IOperation var1, Object[] var2);
    }

    public static interface SetBearerTokenAuthenticationConfiguration {
        public void set(BaSyxContext var1, String var2, String var3, String var4);
    }

    public static interface SetupBaSyxAASServerConfiguration {
        public void setup(BaSyxAASServerConfiguration var1);
    }

    public static interface ServerCreator {
        public Server createServer(DeploymentSpec var1, SetupSpec var2, SetupSpec.AasComponent var3);
    }

    public static interface RegistryDeploymentServerCreator {
        public BaSyxAbstractAasServer createRegistryDeploymentServer(DeploymentSpec var1, SetupSpec var2, SetupSpec.AasComponent var3, String var4, AASServerBackend var5, String ... var6);
    }
}

