/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.map.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.api.parts.IConceptDictionary;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.reference.ReferenceHelper;
import org.eclipse.basyx.vab.model.VABModelMap;

public class ConceptDictionary
extends VABModelMap<Object>
implements IConceptDictionary {
    public static final String CONCEPTDESCRIPTION = "conceptDescription";
    public static final String CONCEPTDESCRIPTIONS = "conceptDescriptions";

    public ConceptDictionary() {
        this.put(CONCEPTDESCRIPTION, new ArrayList());
        this.put(CONCEPTDESCRIPTIONS, new ArrayList());
    }

    public ConceptDictionary(String idShort) {
        this();
        this.setIdShort(idShort);
    }

    public ConceptDictionary(Collection<IReference> ref) {
        this.putAll(new Referable());
        this.put(CONCEPTDESCRIPTION, ref);
        this.put(CONCEPTDESCRIPTIONS, new ArrayList());
    }

    public static ConceptDictionary createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (!ConceptDictionary.isValid(map)) {
            throw new MetamodelConstructionException(ConceptDictionary.class, map);
        }
        ConceptDictionary ret = new ConceptDictionary();
        ret.setMap(map);
        return ret;
    }

    public static boolean isValid(Map<String, Object> map) {
        return Referable.isValid(map);
    }

    @Override
    public String getIdShort() {
        return Referable.createAsFacade(this, this.getKeyElement()).getIdShort();
    }

    @Override
    public String getCategory() {
        return Referable.createAsFacade(this, this.getKeyElement()).getCategory();
    }

    @Override
    public LangStrings getDescription() {
        return Referable.createAsFacade(this, this.getKeyElement()).getDescription();
    }

    @Override
    public IReference getParent() {
        return Referable.createAsFacade(this, this.getKeyElement()).getParent();
    }

    public void setIdShort(String idShort) {
        Referable.createAsFacadeNonStrict(this, this.getKeyElement()).setIdShort(idShort);
    }

    public void setCategory(String category) {
        Referable.createAsFacade(this, this.getKeyElement()).setCategory(category);
    }

    public void setDescription(LangStrings description) {
        Referable.createAsFacade(this, this.getKeyElement()).setDescription(description);
    }

    public void setParent(IReference obj) {
        Referable.createAsFacade(this, this.getKeyElement()).setParent(obj);
    }

    @Override
    public Collection<IReference> getConceptDescriptionReferences() {
        return ReferenceHelper.transform(this.get(CONCEPTDESCRIPTION));
    }

    public void setConceptDescriptionReferences(Collection<IReference> ref) {
        this.put(CONCEPTDESCRIPTION, ref);
    }

    public void setConceptDescriptions(Collection<IConceptDescription> descriptions) {
        this.put(CONCEPTDESCRIPTIONS, descriptions);
        ArrayList<IReference> refs = new ArrayList<IReference>();
        for (IConceptDescription desc : descriptions) {
            refs.add(this.createConceptDescriptionRef(desc));
        }
        this.setConceptDescriptionReferences(refs);
    }

    public void addConceptDescription(IConceptDescription description) {
        Collection desc = (Collection)this.get(CONCEPTDESCRIPTIONS);
        desc.add(description);
        Collection refs = (Collection)this.get(CONCEPTDESCRIPTION);
        refs.add(this.createConceptDescriptionRef(description));
    }

    private IReference createConceptDescriptionRef(IConceptDescription description) {
        IIdentifier id = description.getIdentification();
        return new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, true, id.getId(), id.getIdType()));
    }

    @Override
    public Collection<IConceptDescription> getConceptDescriptions() {
        return (Collection)this.get(CONCEPTDESCRIPTIONS);
    }

    private KeyElements getKeyElement() {
        return KeyElements.CONCEPTDICTIONARY;
    }

    @Override
    public IReference getReference() {
        return Referable.createAsFacade(this, this.getKeyElement()).getReference();
    }
}

