/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRule;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleDTO;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleSet;
import org.eclipse.basyx.extensions.shared.authorization.internal.TagTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.TargetInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacRuleSetDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(RbacRuleSetDeserializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RbacRuleSetDeserializer() {
        this(mapper -> {});
    }

    public RbacRuleSetDeserializer(Consumer<ObjectMapper> objectMapperConsumer) {
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.addMixIn(RbacRule.class, RbacRuleMixin.class);
        this.objectMapper.addMixIn(TargetInformation.class, TargetInformationMixin.class).registerSubtypes(new NamedType[]{new NamedType(BaSyxObjectTargetInformation.class, "basyx"), new NamedType(TagTargetInformation.class, "tag")});
        objectMapperConsumer.accept(this.objectMapper);
    }

    public RbacRuleSet fromFile(String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath must not be null");
        }
        logger.info("loading rbac rules...");
        try (InputStream inputStream = this.getInputStreamFromFile(filePath);){
            Object[] rbacRules = this.deserialize(inputStream);
            logger.info("Read rbac rules: {}", (Object)Arrays.toString(rbacRules));
            RbacRuleSet rbacRuleSet = new RbacRuleSet();
            Arrays.stream(rbacRules).forEach(rbacRuleSet::addRule);
            RbacRuleSet rbacRuleSet2 = rbacRuleSet;
            return rbacRuleSet2;
        }
    }

    private InputStream getInputStreamFromFile(String filePath) throws IOException {
        try {
            FileInputStream inputStream = new FileInputStream(filePath);
            logger.info("read {} from file system", (Object)filePath);
            return inputStream;
        }
        catch (FileNotFoundException e) {
            logger.info("did not find {} in file system, try classpath next", (Object)filePath);
            try {
                InputStream inputStream = RbacRuleSet.class.getResourceAsStream(filePath);
                if (inputStream == null) {
                    throw new FileNotFoundException("could not find " + filePath);
                }
                logger.info("read {} from classpath", (Object)filePath);
                return inputStream;
            }
            catch (FileNotFoundException e2) {
                logger.info("did not find {} on classpath, give up", (Object)filePath);
                throw new IOException("could not find " + filePath);
            }
        }
    }

    private <T, U> List<Pair<T, U>> cartesianProduct2(T[] firsts, U[] seconds) {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>();
        for (T first : firsts) {
            for (U second : seconds) {
                result.add(new Pair<T, U>(first, second));
            }
        }
        return result;
    }

    public RbacRule[] deserialize(InputStream inputStream) throws IOException {
        RbacRuleMultiple[] rbacRulesRaw = (RbacRuleMultiple[])this.objectMapper.readValue(inputStream, RbacRuleMultiple[].class);
        return (RbacRule[])Arrays.stream(rbacRulesRaw).flatMap(raw -> this.cartesianProduct2(raw.actions, raw.targetInformation).stream().map(pair -> (RbacRule)this.objectMapper.convertValue((Object)new RbacRuleDTO(raw.role, (String)pair.first, (Map)pair.second), RbacRule.class))).toArray(RbacRule[]::new);
    }

    private static class Pair<T, U> {
        private final T first;
        private final U second;

        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }
    }

    private static class RbacRuleMultiple {
        String role;
        String[] actions;
        Map<String, String>[] targetInformation;

        public RbacRuleMultiple() {
        }

        public RbacRuleMultiple(@JsonProperty(value="role") String role, @JsonProperty(value="action") String[] actions, @JsonProperty(value="targetInformation") Map<String, String>[] targetInformation) {
            this.role = role;
            this.actions = actions;
            this.targetInformation = targetInformation;
        }

        public String getRole() {
            return this.role;
        }

        public String[] getActions() {
            return this.actions;
        }

        public Map<String, String>[] getTargetInformation() {
            return this.targetInformation;
        }
    }

    public static class RbacRuleMixin {
        @JsonCreator
        public RbacRuleMixin(@JsonProperty(value="role") String role, @JsonProperty(value="action") String action, @JsonProperty(value="targetInformation") TargetInformation targetInformation) {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    public static class TargetInformationMixin {
    }
}

