/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.TargetInformation;

public class SimpleRbacInhibitException
extends InhibitException {
    private final List<String> roles;
    private final String action;
    private final TargetInformation targetInformation;

    public SimpleRbacInhibitException(List<String> roles, String action, TargetInformation targetInformation) {
        this(SimpleRbacInhibitException.createMessage(action, targetInformation, roles), roles, action, targetInformation);
    }

    private SimpleRbacInhibitException(String message, List<String> roles, String action, TargetInformation targetInformation) {
        super(message);
        this.roles = roles;
        this.action = action;
        this.targetInformation = targetInformation;
    }

    private static String createMessage(String action, TargetInformation targetInformation, List<String> roles) {
        String targetInformationString = targetInformation.toString();
        String rolesString = Arrays.toString(roles.toArray());
        return String.format("no rule matching action=%s, targetInfo=%s role=(any of %s)", action, targetInformationString, rolesString);
    }

    @Override
    public InhibitException reduceSmIdToSmIdShortPath(String smIdShortPath) {
        TargetInformation messageTargetInformation = this.reduceSmIdToSmIdShortPath_convertTargetInformation(smIdShortPath);
        return new SimpleRbacInhibitException(SimpleRbacInhibitException.createMessage(this.action, messageTargetInformation, this.roles), this.roles, this.action, this.targetInformation);
    }

    private TargetInformation reduceSmIdToSmIdShortPath_convertTargetInformation(String smIdShortPath) {
        if (this.targetInformation instanceof BaSyxObjectTargetInformation) {
            return new BaSyxObjectTargetInformation(((BaSyxObjectTargetInformation)this.targetInformation).getAasId(), ((BaSyxObjectTargetInformation)this.targetInformation).getSmId(), ((BaSyxObjectTargetInformation)this.targetInformation).getSmSemanticId(), String.format("(id of %s)", smIdShortPath));
        }
        return this.targetInformation;
    }
}

