/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.aggregator.mqtt;

import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.extensions.submodel.aggregator.mqtt.MqttSubmodelAggregatorHelper;
import org.eclipse.basyx.submodel.aggregator.observing.ISubmodelAggregatorObserver;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSubmodelAggregatorObserver
extends MqttEventService
implements ISubmodelAggregatorObserver {
    private static Logger logger = LoggerFactory.getLogger(MqttSubmodelAggregatorObserver.class);

    public MqttSubmodelAggregatorObserver(String serverEndpoint, String clientId) throws MqttException {
        super(serverEndpoint, clientId);
        logger.info("Create new MQTT Submodel Aggregator Observer for endpoint " + serverEndpoint);
    }

    public MqttSubmodelAggregatorObserver(String serverEndpoint, String clientId, String user, char[] pw) throws MqttException {
        super(serverEndpoint, clientId, user, pw);
        logger.info("Create new MQTT Submodel Aggregator Observer for endpoint " + serverEndpoint);
    }

    public MqttSubmodelAggregatorObserver(MqttClient client) throws MqttException {
        super(client);
        logger.info("Create new MQTT Submodel Aggregator Observer for endpoint " + client.getServerURI());
    }

    public MqttSubmodelAggregatorObserver(String serverEndpoint, String clientId, MqttClientPersistence persistence) throws MqttException {
        super(serverEndpoint, clientId, persistence);
        logger.info("Create new MQTT Submodel Aggregator Observer for endpoint " + serverEndpoint);
    }

    public MqttSubmodelAggregatorObserver(String serverEndpoint, String clientId, String user, char[] pw, MqttClientPersistence persistence) throws MqttException {
        super(serverEndpoint, clientId, user, pw, persistence);
        logger.info("Create new MQTT Submodel Aggregator Observer for endpoint " + serverEndpoint);
    }

    @Override
    public void submodelCreated(String shellId, String submodelId) {
        this.sendMqttMessage("BaSyxAggregator_createdSubmodel", MqttSubmodelAggregatorHelper.getCombinedMessage(shellId, submodelId));
    }

    @Override
    public void submodelUpdated(String shellId, String submodelId) {
        this.sendMqttMessage("BaSyxAggregator_updatedSubmodel", MqttSubmodelAggregatorHelper.getCombinedMessage(shellId, submodelId));
    }

    @Override
    public void submodelDeleted(String shellId, String submodelId) {
        this.sendMqttMessage("BaSyxAggregator_deletedSubmodel", MqttSubmodelAggregatorHelper.getCombinedMessage(shellId, submodelId));
    }
}

