/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.delegation;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.basyx.extensions.submodel.delegation.PropertyDelegationManager;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IConstraint;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;

public class DelegatingSubmodelAPI
implements ISubmodelAPI {
    private ISubmodelAPI decoratedSubmodelAPI;
    private PropertyDelegationManager delegationProvider;

    public DelegatingSubmodelAPI(ISubmodelAPI decoratedSubmodelAPI, PropertyDelegationManager delegationManager) {
        this.delegationProvider = delegationManager;
        this.decoratedSubmodelAPI = decoratedSubmodelAPI;
        this.handleSubmodel(decoratedSubmodelAPI);
    }

    @Override
    public ISubmodel getSubmodel() {
        return this.decoratedSubmodelAPI.getSubmodel();
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        this.delegationProvider.handleSubmodelElement((SubmodelElement)elem);
        this.decoratedSubmodelAPI.addSubmodelElement(elem);
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        this.delegationProvider.handleSubmodelElement((SubmodelElement)elem);
        this.decoratedSubmodelAPI.addSubmodelElement(idShortPath, elem);
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        return this.decoratedSubmodelAPI.getSubmodelElement(idShortPath);
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        this.decoratedSubmodelAPI.deleteSubmodelElement(idShortPath);
    }

    @Override
    public Collection<IOperation> getOperations() {
        return this.decoratedSubmodelAPI.getOperations();
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        return this.decoratedSubmodelAPI.getSubmodelElements();
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        this.handleUpdateSubmodelElementValueRequest((SubmodelElement)this.decoratedSubmodelAPI.getSubmodelElement(idShortPath));
        this.decoratedSubmodelAPI.updateSubmodelElement(idShortPath, newValue);
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        return this.decoratedSubmodelAPI.getSubmodelElementValue(idShortPath);
    }

    @Override
    public Object invokeOperation(String idShortPath, Object ... params) {
        return this.decoratedSubmodelAPI.invokeOperation(idShortPath, params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        return this.decoratedSubmodelAPI.invokeAsync(idShortPath, params);
    }

    @Override
    public Object getOperationResult(String idShort, String requestId) {
        return this.decoratedSubmodelAPI.getOperationResult(idShort, requestId);
    }

    private void handleSubmodel(ISubmodelAPI decoratedSubmodelAPI) {
        ISubmodel submodel = decoratedSubmodelAPI.getSubmodel();
        this.delegationProvider.handleSubmodel(submodel);
        submodel.getSubmodelElements().values().stream().forEach(decoratedSubmodelAPI::addSubmodelElement);
    }

    private void handleUpdateSubmodelElementValueRequest(SubmodelElement submodelElement) {
        if (!Property.isProperty(submodelElement)) {
            return;
        }
        this.throwAnExceptionIfDelegatedQualifierIsPresent(submodelElement);
    }

    private void throwAnExceptionIfDelegatedQualifierIsPresent(ISubmodelElement element) {
        Collection<IConstraint> qualifiers = element.getQualifiers();
        Optional<IConstraint> optionalConstraint = qualifiers.stream().filter(PropertyDelegationManager::isDelegationQualifier).findAny();
        if (!optionalConstraint.isEmpty()) {
            throw new MalformedRequestException("The update request on this SubmodelElement " + element.getIdShort() + " with delegated qualifier is not allowed");
        }
    }

    @Override
    public File getSubmodelElementFile(String idShortPath) {
        return this.decoratedSubmodelAPI.getSubmodelElementFile(idShortPath);
    }

    @Override
    public void uploadSubmodelElementFile(String idShortPath, InputStream fileStream) {
        this.decoratedSubmodelAPI.uploadSubmodelElementFile(idShortPath, fileStream);
    }
}

