/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.mqtt;

import org.eclipse.basyx.extensions.submodel.mqtt.MqttSubmodelAPIHelper;
import org.eclipse.basyx.extensions.submodel.mqtt.MqttSubmodelAPIObserver;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.submodel.restapi.observing.ObservableSubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttDecoratingSubmodelAPIFactory
implements ISubmodelAPIFactory {
    private ISubmodelAPIFactory apiFactory;
    private MqttClient client;

    public MqttDecoratingSubmodelAPIFactory(ISubmodelAPIFactory factoryToBeDecorated, MqttClient client) {
        this.apiFactory = factoryToBeDecorated;
        this.client = client;
    }

    @Override
    public ISubmodelAPI getSubmodelAPI(Submodel submodel) {
        try {
            ObservableSubmodelAPI observedAPI = new ObservableSubmodelAPI(this.apiFactory.create(submodel));
            MqttSubmodelAPIObserver mqttSubmodelAPIObserver = new MqttSubmodelAPIObserver(this.client, MqttSubmodelAPIHelper.getAASId(observedAPI), MqttSubmodelAPIHelper.getSubmodelId(observedAPI));
            observedAPI.addObserver(mqttSubmodelAPIObserver);
            return observedAPI;
        }
        catch (MqttException e) {
            throw new ProviderException(e);
        }
    }
}

