/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.aggregator.observing;

import java.util.Collection;
import java.util.List;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.aggregator.observing.ISubmodelAggregatorObserverV2;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.observer.Observable;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class ObservableSubmodelAggregatorV2
extends Observable<ISubmodelAggregatorObserverV2>
implements ISubmodelAggregator {
    private ISubmodelAggregator submodelAggregator;
    private String aasServerId = "aas-server";

    public ObservableSubmodelAggregatorV2(ISubmodelAggregator aggregator, String aasServerId) {
        this.submodelAggregator = aggregator;
        this.aasServerId = aasServerId;
    }

    public String getAasServerId() {
        return this.aasServerId;
    }

    @Override
    public Collection<ISubmodel> getSubmodelList() {
        return this.submodelAggregator.getSubmodelList();
    }

    @Override
    public ISubmodel getSubmodel(IIdentifier submodelIdentifier) throws ResourceNotFoundException {
        return this.submodelAggregator.getSubmodel(submodelIdentifier);
    }

    @Override
    public ISubmodel getSubmodelbyIdShort(String submodelIdShort) throws ResourceNotFoundException {
        return this.submodelAggregator.getSubmodelbyIdShort(submodelIdShort);
    }

    @Override
    public ISubmodelAPI getSubmodelAPIById(IIdentifier submodelIdentifier) throws ResourceNotFoundException {
        return this.submodelAggregator.getSubmodelAPIById(submodelIdentifier);
    }

    @Override
    public ISubmodelAPI getSubmodelAPIByIdShort(String submodelIdShort) throws ResourceNotFoundException {
        return this.submodelAggregator.getSubmodelAPIByIdShort(submodelIdShort);
    }

    @Override
    public void createSubmodel(Submodel submodel) {
        this.submodelAggregator.createSubmodel(submodel);
        this.observers.stream().forEach(observer -> observer.submodelCreated(this.getParentAASId(submodel), submodel, this.aasServerId));
    }

    @Override
    public void createSubmodel(ISubmodelAPI submodelAPI) {
        this.submodelAggregator.createSubmodel(submodelAPI);
    }

    @Override
    public void updateSubmodel(Submodel submodel) throws ResourceNotFoundException {
        this.submodelAggregator.updateSubmodel(submodel);
        this.observers.stream().forEach(observer -> observer.submodelUpdated(this.getParentAASId(submodel), submodel, this.aasServerId));
    }

    @Override
    public void deleteSubmodelByIdentifier(IIdentifier submodelIdentifier) {
        ISubmodel submodel = this.submodelAggregator.getSubmodel(submodelIdentifier);
        String parentAASId = this.getParentAASId(submodel);
        this.submodelAggregator.deleteSubmodelByIdentifier(submodelIdentifier);
        this.observers.stream().forEach(observer -> observer.submodelDeleted(parentAASId, submodel, this.aasServerId));
    }

    @Override
    public void deleteSubmodelByIdShort(String submodelIdShort) {
        ISubmodel submodel = this.submodelAggregator.getSubmodelbyIdShort(submodelIdShort);
        String parentAASId = this.getParentAASId(submodel);
        this.submodelAggregator.deleteSubmodelByIdShort(submodelIdShort);
        this.observers.stream().forEach(observer -> observer.submodelDeleted(parentAASId, submodel, this.aasServerId));
    }

    private String getParentAASId(ISubmodel submodel) {
        IReference parentReference = submodel.getParent();
        if (parentReference == null) {
            return null;
        }
        List<IKey> keys = parentReference.getKeys();
        if (keys != null && keys.size() > 0) {
            return keys.get(0).getValue();
        }
        return null;
    }
}

