/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IFile;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement;

public class File
extends DataElement
implements IFile {
    public static final String MIMETYPE = "mimeType";
    public static final String MODELTYPE = "File";

    public File() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public File(String mimeType) {
        this();
        this.setMimeType(mimeType);
    }

    public File(String value, String mimeType) {
        this.putAll(new ModelType(MODELTYPE));
        this.put("value", value);
        this.put(MIMETYPE, mimeType);
    }

    public static File createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!File.isValid(obj)) {
            throw new MetamodelConstructionException(File.class, obj);
        }
        File facade = new File();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return DataElement.isValid(obj) && obj.containsKey(MIMETYPE);
    }

    public static boolean isFile(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey("value") && map.containsKey(MIMETYPE);
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Given Object is not a String");
        }
        this.setValue((String)value);
    }

    @Override
    public String getValue() {
        return (String)this.get("value");
    }

    public void setMimeType(String mimeType) {
        this.put(MIMETYPE, mimeType);
    }

    @Override
    public String getMimeType() {
        return (String)this.get(MIMETYPE);
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.FILE;
    }

    @Override
    public File getLocalCopy() {
        File copy = new File();
        copy.putAll(this);
        return copy;
    }

    @Override
    public void setValue(String value) {
        this.put("value", value);
    }
}

