/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.address;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.types.digitalnameplate.enums.MailType;

public class Email
extends SubmodelElementCollection {
    public static final String EMAILADDRESSID = "EmailAddress";
    public static final String PUBLICKEYID = "PublicKey";
    public static final String TYPEOFEMAILADDRESSID = "TypeOfEmailAddress";
    public static final String TYPEOFPUBLICKEYID = "TypeOfPublickKey";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAQ836#005", KeyType.IRDI));

    private Email() {
    }

    public Email(String idShort, Property emailAddress) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setEmailAddress(emailAddress);
    }

    public Email(String idShort, String emailAddress) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setEmailAddress(emailAddress);
    }

    public static Email createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Email.isValid(obj)) {
            throw new MetamodelConstructionException(Email.class, obj);
        }
        Email email = new Email();
        email.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return email;
    }

    private static Email createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        Email email = new Email();
        email.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return email;
    }

    public static boolean isValid(Map<String, Object> obj) {
        Email email = Email.createAsFacadeNonStrict(obj);
        return SubmodelElementCollection.isValid(obj) && Property.isValid((Map)((Object)email.getEmailAddress()));
    }

    public void setEmailAddress(Property emailAddress) {
        this.addSubmodelElement(emailAddress);
    }

    public void setEmailAddress(String emailAddress) {
        Property emailProp = new Property(EMAILADDRESSID, ValueType.String);
        emailProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO198#002", IdentifierType.IRDI)));
        emailProp.setValue(emailAddress);
        this.setEmailAddress(emailProp);
    }

    public IProperty getEmailAddress() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(EMAILADDRESSID)));
    }

    public void setPublicKey(MultiLanguageProperty key) {
        this.addSubmodelElement(key);
    }

    public void setPublicKey(LangString key) {
        MultiLanguageProperty publicKey = new MultiLanguageProperty(PUBLICKEYID);
        publicKey.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO200#002", IdentifierType.IRDI)));
        publicKey.setValue(new LangStrings(key));
        this.setPublicKey(publicKey);
    }

    public IMultiLanguageProperty getPublicKey() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(PUBLICKEYID)));
    }

    public void setTypeOfEmailAddress(Property type) {
        this.addSubmodelElement(type);
    }

    public void setTypeOfEmailAddress(MailType type) {
        Property mailTypeProp = new Property(TYPEOFEMAILADDRESSID, ValueType.String);
        mailTypeProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO199#003", IdentifierType.IRDI)));
        mailTypeProp.setValue(type.toString());
        this.setTypeOfEmailAddress(mailTypeProp);
    }

    public IProperty getTypeOfEmailAddress() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(TYPEOFEMAILADDRESSID)));
    }

    public void setTypeOfPublicKey(MultiLanguageProperty key) {
        this.addSubmodelElement(key);
    }

    public void setTypeOfPublicKey(LangString key) {
        MultiLanguageProperty typeOfPublicKey = new MultiLanguageProperty(TYPEOFPUBLICKEYID);
        typeOfPublicKey.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO201#002", IdentifierType.IRDI)));
        typeOfPublicKey.setValue(new LangStrings(key));
        this.setTypeOfPublicKey(typeOfPublicKey);
    }

    public IMultiLanguageProperty getTypeOfPublicKey() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(TYPEOFPUBLICKEYID)));
    }
}

