/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.modelprovider.lambda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.map.VABMapHandler;

public class VABLambdaHandler
extends VABMapHandler {
    public static final String VALUE_SET_SUFFIX = "set";
    public static final String VALUE_GET_SUFFIX = "get";
    public static final String VALUE_INSERT_SUFFIX = "insert";
    public static final String VALUE_REMOVEKEY_SUFFIX = "removeKey";
    public static final String VALUE_REMOVEOBJ_SUFFIX = "removeObject";

    @Override
    public Object postprocessObject(Object element) {
        return super.postprocessObject(this.resolveAll(element));
    }

    @Override
    public Object getElementProperty(Object element, String propertyName) {
        return super.getElementProperty(this.resolveSingle(element), propertyName);
    }

    @Override
    public void setModelPropertyValue(Object element, String propertyName, Object newValue) {
        Object child = null;
        try {
            child = this.getElementProperty(element, propertyName);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        if (this.hasHiddenSetter(child)) {
            ((Consumer)((Map)child).get(VALUE_SET_SUFFIX)).accept(newValue);
        } else if (this.hasHiddenInserter(element) && this.resolveSingle(element) instanceof Map) {
            ((BiConsumer)((Map)element).get(VALUE_INSERT_SUFFIX)).accept(propertyName, newValue);
        } else {
            super.setModelPropertyValue(this.resolveSingle(element), propertyName, newValue);
        }
    }

    @Override
    public void createValue(Object element, Object newValue) {
        if (this.hasHiddenInserter(element)) {
            ((Consumer)((Map)element).get(VALUE_INSERT_SUFFIX)).accept(newValue);
        } else {
            super.createValue(element, newValue);
        }
    }

    @Override
    public void deleteValue(Object element, String propertyName) {
        if (this.hasHiddenKeyRemover(element)) {
            super.getElementProperty(this.resolveSingle(element), propertyName);
            Consumer c = (Consumer)((Map)element).get(VALUE_REMOVEKEY_SUFFIX);
            c.accept(propertyName);
        } else {
            super.deleteValue(element, propertyName);
        }
    }

    @Override
    public void deleteValue(Object element, Object property) {
        if (this.hasHiddenObjectRemover(element)) {
            if (this.resolveSingle(element) instanceof Map) {
                throw new MalformedRequestException("Could not delete property from a map.");
            }
            Consumer c = (Consumer)((Map)element).get(VALUE_REMOVEOBJ_SUFFIX);
            c.accept(property);
        } else {
            super.deleteValue(element, property);
        }
    }

    private Object resolveSingle(Object o) {
        while (this.hasHiddenGetter(o)) {
            Map map = (Map)o;
            o = ((Supplier)map.get(VALUE_GET_SUFFIX)).get();
        }
        return o;
    }

    private Object resolveAll(Object o) {
        if ((o = this.resolveSingle(o)) instanceof Map) {
            return this.resolveMap((Map)o);
        }
        if (o instanceof Collection) {
            return this.resolveCollection((Collection)o);
        }
        return o;
    }

    private Object resolveMap(Map<String, Object> map) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (String s : map.keySet()) {
            ret.put(s, this.resolveAll(map.get(s)));
        }
        return ret;
    }

    private Object resolveCollection(Collection<Object> coll) {
        ArrayList<Object> ret = new ArrayList<Object>(coll.size());
        for (Object o : coll) {
            ret.add(this.resolveAll(o));
        }
        return ret;
    }

    private boolean hasHiddenInserter(Object elem) {
        if (elem instanceof Map) {
            Map map = (Map)elem;
            Object o = map.get(VALUE_INSERT_SUFFIX);
            return o instanceof BiConsumer || o instanceof Consumer;
        }
        return false;
    }

    private boolean hasHiddenObjectRemover(Object elem) {
        if (elem instanceof Map) {
            Map map = (Map)elem;
            Object o = map.get(VALUE_REMOVEOBJ_SUFFIX);
            return o instanceof Consumer;
        }
        return false;
    }

    private boolean hasHiddenKeyRemover(Object elem) {
        if (elem instanceof Map) {
            Map map = (Map)elem;
            Object o = map.get(VALUE_REMOVEKEY_SUFFIX);
            return o instanceof Consumer;
        }
        return false;
    }

    private boolean hasHiddenSetter(Object elem) {
        if (elem instanceof Map) {
            Map map = (Map)elem;
            Object o = map.get(VALUE_SET_SUFFIX);
            return o instanceof Consumer;
        }
        return false;
    }

    private boolean hasHiddenGetter(Object elem) {
        if (elem instanceof Map) {
            Map map = (Map)elem;
            Object o = map.get(VALUE_GET_SUFFIX);
            return o instanceof Supplier;
        }
        return false;
    }
}

