/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.mqtt;

import org.eclipse.basyx.extensions.shared.mqtt.PayloadParserHelper;
import org.eclipse.basyx.vab.exception.provider.ProviderException;

public class MqttSubmodelAPIPayloadParser
extends PayloadParserHelper {
    private String payload;
    private String submodelId;
    private String shellId;
    private String submodelElementIdShort;

    public MqttSubmodelAPIPayloadParser(String payload) {
        this.payload = payload;
        if (this.payload.startsWith("(")) {
            this.submodelId = this.getSubmodelIdFromPayload();
            this.shellId = this.getShellIdFromPayload();
            this.submodelElementIdShort = this.getSubmodelElementIdShortFromPayload();
        } else {
            this.submodelId = payload;
        }
    }

    public String extractSubmodelId() {
        return this.submodelId;
    }

    public String extractShellId() {
        if (!this.payload.startsWith("(")) {
            throw new ProviderException("Payload '" + this.payload + "' does not conatin a shellId.");
        }
        return this.shellId;
    }

    public String extractSubmodelElementIdShort() {
        if (!this.payload.startsWith("(")) {
            throw new ProviderException("Payload '" + this.payload + "' does not conatin a Submodel Element ID short.");
        }
        return this.submodelElementIdShort;
    }

    private String getShellIdFromPayload() {
        return MqttSubmodelAPIPayloadParser.extractIds(this.payload)[0];
    }

    private String getSubmodelIdFromPayload() {
        return MqttSubmodelAPIPayloadParser.extractIds(this.payload)[1];
    }

    private String getSubmodelElementIdShortFromPayload() {
        return MqttSubmodelAPIPayloadParser.extractIds(this.payload)[2];
    }
}

