/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;

public class BaSyxContextConfiguration
extends BaSyxConfiguration {
    public static final String ENV_PREFIX = "BaSyxContext_";
    public static final String DEFAULT_CONTEXTPATH = "basys.sdk";
    public static final String DEFAULT_DOCBASE = System.getProperty("java.io.tmpdir");
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 4000;
    public static final String CONTEXTPATH = "contextPath";
    public static final String DOCBASE = "contextDocPath";
    public static final String HOSTNAME = "contextHostname";
    public static final String PORT = "contextPort";
    public static final String SSL_KEY_STORE_LOCATION = "sslKeyStoreLocation";
    public static final String SSL_KEY_PASSWORD = "sslKeyPass";
    public static final String JWT_BEARER_TOKEN_AUTHENTICATION_ISSUER_URI = "jwtBearerTokenAuthenticationIssuerUri";
    public static final String JWT_BEARER_TOKEN_AUTHENTICATION_JWK_SET_URI = "jwtBearerTokenAuthenticationJwkSetUri";
    public static final String JWT_BEARER_TOKEN_AUTHENTICATION_REQUIRED_AUD = "jwtBearerTokenAuthenticationRequiredAud";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "accessControlAllowOrigin";
    public static final String DEFAULT_CONFIG_PATH = "context.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_CONTEXT";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(CONTEXTPATH, DEFAULT_CONTEXTPATH);
        defaultProps.put(DOCBASE, DEFAULT_DOCBASE);
        defaultProps.put(HOSTNAME, DEFAULT_HOSTNAME);
        defaultProps.put(PORT, Integer.toString(4000));
        defaultProps.put(SSL_KEY_STORE_LOCATION, null);
        defaultProps.put(SSL_KEY_PASSWORD, null);
        defaultProps.put(ACCESS_CONTROL_ALLOW_ORIGIN, null);
        return defaultProps;
    }

    public BaSyxContextConfiguration() {
        super(BaSyxContextConfiguration.getDefaultProperties(), BaSyxContextConfiguration.getPropertiesExcludedFromLogging());
    }

    public BaSyxContextConfiguration(Map<String, String> values) {
        super(values, BaSyxContextConfiguration.getPropertiesExcludedFromLogging());
    }

    public BaSyxContextConfiguration(int port, String contextPath) {
        this();
        this.setPort(port);
        this.setContextPath(contextPath);
    }

    public BaSyxContextConfiguration(String contextPath, String docBasePath, String hostname, int port) {
        this();
        this.setContextPath(contextPath);
        this.setDocBasePath(docBasePath);
        this.setHostname(hostname);
        this.setPort(port);
    }

    public void loadFromEnvironmentVariables() {
        String[] properties = new String[]{CONTEXTPATH, DOCBASE, HOSTNAME, PORT, JWT_BEARER_TOKEN_AUTHENTICATION_ISSUER_URI, JWT_BEARER_TOKEN_AUTHENTICATION_JWK_SET_URI, JWT_BEARER_TOKEN_AUTHENTICATION_REQUIRED_AUD, ACCESS_CONTROL_ALLOW_ORIGIN};
        this.loadFromEnvironmentVariables(ENV_PREFIX, properties);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
        this.loadFromEnvironmentVariables();
    }

    public BaSyxContext createBaSyxContext() {
        String reqContextPath = this.getContextPath();
        String reqDocBasePath = this.getDocBasePath();
        String hostName = this.getHostname();
        Boolean isSecuredCon = this.isSecureConnection();
        String sslKeyStoreLocation = this.getSSLKeyStoreLocation();
        String sslKeyPass = this.getSSLKeyPassword();
        int reqPort = this.getPort();
        BaSyxContext baSyxContext = isSecuredCon == false ? new BaSyxContext(reqContextPath, reqDocBasePath, hostName, reqPort) : new BaSyxContext(reqContextPath, reqDocBasePath, hostName, reqPort, isSecuredCon.booleanValue(), sslKeyStoreLocation, sslKeyPass);
        if (this.atLeastOneJwtPropertyIsSet()) {
            this.configureJwtAuthentication(baSyxContext);
        }
        this.enableCORSIfConfigured(baSyxContext);
        return baSyxContext;
    }

    private void enableCORSIfConfigured(BaSyxContext baSyxContext) {
        if (!this.isCorsConfigured()) {
            return;
        }
        baSyxContext.setAccessControlAllowOrigin(this.getAccessControlAllowOrigin());
    }

    private boolean isCorsConfigured() {
        return this.getAccessControlAllowOrigin() != null && !this.getAccessControlAllowOrigin().isEmpty();
    }

    private Boolean isSecureConnection() {
        return this.getSSLKeyStoreLocation() != null && this.getSSLKeyPassword() != null;
    }

    private boolean atLeastOneJwtPropertyIsSet() {
        return this.getJwtBearerTokenAuthenticationIssuerUri() != null || this.getJwtBearerTokenAuthenticationJwkSetUri() != null || this.getJwtBearerTokenAuthenticationRequiredAud() != null;
    }

    private void configureJwtAuthentication(BaSyxContext baSyxContext) {
        baSyxContext.setJwtBearerTokenAuthenticationConfiguration(JwtBearerTokenAuthenticationConfiguration.of((String)this.getJwtBearerTokenAuthenticationIssuerUri(), (String)this.getJwtBearerTokenAuthenticationJwkSetUri(), (String)this.getJwtBearerTokenAuthenticationRequiredAud()));
    }

    public String getContextPath() {
        return this.getProperty(CONTEXTPATH);
    }

    public void setContextPath(String contextPath) {
        this.setProperty(CONTEXTPATH, VABPathTools.stripSlashes((String)contextPath));
    }

    public String getDocBasePath() {
        return this.getProperty(DOCBASE);
    }

    public void setDocBasePath(String docBasePath) {
        this.setProperty(DOCBASE, docBasePath);
    }

    public String getHostname() {
        return this.getProperty(HOSTNAME);
    }

    public void setHostname(String hostname) {
        this.setProperty(HOSTNAME, hostname);
    }

    public int getPort() {
        return Integer.parseInt(this.getProperty(PORT));
    }

    public void setPort(int port) {
        this.setProperty(PORT, Integer.toString(port));
    }

    public String getSSLKeyPassword() {
        return this.getProperty(SSL_KEY_PASSWORD);
    }

    public void setSSLKeyPassword(String sslKeyPass) {
        this.setProperty(SSL_KEY_PASSWORD, sslKeyPass);
    }

    public String getSSLKeyStoreLocation() {
        return this.getProperty(SSL_KEY_STORE_LOCATION);
    }

    public void setSSLKeyStoreLocation(String sslKeyStoreLocation) {
        this.setProperty(SSL_KEY_STORE_LOCATION, sslKeyStoreLocation);
    }

    public String getJwtBearerTokenAuthenticationIssuerUri() {
        return this.getProperty(JWT_BEARER_TOKEN_AUTHENTICATION_ISSUER_URI);
    }

    public void setJwtBearerTokenAuthenticationIssuerUri(String jwtBearerAuthIssuerUri) {
        this.setProperty(JWT_BEARER_TOKEN_AUTHENTICATION_ISSUER_URI, jwtBearerAuthIssuerUri);
    }

    public String getJwtBearerTokenAuthenticationJwkSetUri() {
        return this.getProperty(JWT_BEARER_TOKEN_AUTHENTICATION_JWK_SET_URI);
    }

    public void setJwtBearerTokenAuthenticationJwkSetUri(String jwtBearerAuthJwkSetUri) {
        this.setProperty(JWT_BEARER_TOKEN_AUTHENTICATION_JWK_SET_URI, jwtBearerAuthJwkSetUri);
    }

    public String getJwtBearerTokenAuthenticationRequiredAud() {
        return this.getProperty(JWT_BEARER_TOKEN_AUTHENTICATION_REQUIRED_AUD);
    }

    public void setJwtBearerTokenAuthenticationRequiredAud(String jwtBearerAuthRequiredAud) {
        this.setProperty(JWT_BEARER_TOKEN_AUTHENTICATION_REQUIRED_AUD, jwtBearerAuthRequiredAud);
    }

    public String getAccessControlAllowOrigin() {
        return this.getProperty(ACCESS_CONTROL_ALLOW_ORIGIN);
    }

    public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.setProperty(ACCESS_CONTROL_ALLOW_ORIGIN, accessControlAllowOrigin);
    }

    public String getUrl() {
        String contextPath = this.getContextPath();
        String base = this.getProtocol() + this.getHostname() + ":" + this.getPort();
        if (contextPath.isEmpty()) {
            return base;
        }
        return VABPathTools.concatenatePaths((String[])new String[]{base, contextPath});
    }

    private String getProtocol() {
        if (this.isSecureConnection().booleanValue()) {
            return "https://";
        }
        return "http://";
    }

    private static List<String> getPropertiesExcludedFromLogging() {
        return Collections.singletonList(SSL_KEY_PASSWORD);
    }
}

