/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.factory.propertymap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.CustomId;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.components.factory.propertymap.PropertyMapConstantsHelper;
import org.eclipse.basyx.components.propertymap.PropertyMapHelper;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;

public class PropertyMapBasedAASFactory {
    public static final String ASSET = "asset";
    public static final String SUBMODELS = "submodels";
    private Map<String, Asset> assetMap = new HashMap<String, Asset>();
    private Map<String, Submodel> submodelMap = new HashMap<String, Submodel>();

    public PropertyMapBasedAASFactory(Map<String, Submodel> submodels, Map<String, Asset> assets) {
        this.submodelMap = submodels;
        this.assetMap = assets;
    }

    public AssetAdministrationShell create(Map<String, String> aasMap) {
        Asset asset = this.getAsset(aasMap);
        AssetAdministrationShell shell = PropertyMapBasedAASFactory.createAASWithoutSubmodels(aasMap, asset);
        this.addSubmodelToAAS(aasMap, shell);
        return shell;
    }

    private void addSubmodelToAAS(Map<String, String> aasMap, AssetAdministrationShell shell) {
        List<Submodel> submodels = this.getSubmodels(aasMap);
        PropertyMapBasedAASFactory.addSubmodelReferences(shell, submodels);
    }

    private static AssetAdministrationShell createAASWithoutSubmodels(Map<String, String> aasMap, Asset asset) {
        String aasId = PropertyMapConstantsHelper.getIdValue(aasMap);
        String aasIdShort = PropertyMapConstantsHelper.getIdShort(aasMap);
        AssetAdministrationShell shell = new AssetAdministrationShell(aasIdShort, (IIdentifier)new CustomId(aasId), asset);
        return shell;
    }

    private static void addSubmodelReferences(AssetAdministrationShell shell, List<Submodel> submodels) {
        submodels.stream().map(sm -> sm.getReference()).forEach(arg_0 -> ((AssetAdministrationShell)shell).addSubmodelReference(arg_0));
    }

    private List<Submodel> getSubmodels(Map<String, String> aasMap) {
        return PropertyMapBasedAASFactory.getSubmodelIds(aasMap).stream().map(id -> this.submodelMap.get(id)).collect(Collectors.toList());
    }

    private Asset getAsset(Map<String, String> aasMap) {
        String assetId = PropertyMapBasedAASFactory.getAssetId(aasMap);
        return this.assetMap.get(assetId);
    }

    private static List<String> getSubmodelIds(Map<String, String> aasMap) {
        String submodels = aasMap.get(SUBMODELS);
        return PropertyMapHelper.getListFromStringList(submodels);
    }

    private static String getAssetId(Map<String, String> aasMap) {
        return aasMap.get(ASSET);
    }
}

