/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Builder;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.DeferredBuilder;
import de.iip_ecosphere.platform.support.aas.Entity;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.RelationshipElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxBlob;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDataElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxElementTranslator;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxEntity;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxFile;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxMultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxOperation;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRange;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReferenceElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRelationshipElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementList;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelParent;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public abstract class AbstractSubmodel<S extends ISubmodel>
implements Submodel,
BaSyxElementTranslator.SubmodelElementsRegistrar {
    private S submodel;
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    private Map<String, DataElement> dataElements = new HashMap<String, DataElement>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Map<String, SubmodelElement> submodelElements = new HashMap<String, SubmodelElement>();
    private Map<String, Builder<?>> deferred;

    protected AbstractSubmodel(S submodel) {
        this.submodel = submodel;
    }

    public S getSubmodel() {
        return this.submodel;
    }

    private void warn(String msg) {
        LoggerFactory.getLogger(this.getClass()).warn(msg);
    }

    @Override
    public BaSyxFile register(BaSyxFile file) {
        String id = file.getIdShort();
        if (this.dataElements.containsKey(id) || this.submodelElements.containsKey(id)) {
            this.warn("There is already an element with short id '" + id + "'. The element may be redefined.");
        }
        this.dataElements.put(id, file);
        this.submodelElements.put(id, file);
        return file;
    }

    @Override
    public BaSyxRange register(BaSyxRange file) {
        String id = file.getIdShort();
        if (this.dataElements.containsKey(id) || this.submodelElements.containsKey(id)) {
            this.warn("There is already an element with short id '" + id + "'. The element may be redefined.");
        }
        this.dataElements.put(id, file);
        this.submodelElements.put(id, file);
        return file;
    }

    @Override
    public BaSyxBlob register(BaSyxBlob blob) {
        String id = blob.getIdShort();
        if (this.dataElements.containsKey(id) || this.submodelElements.containsKey(id)) {
            this.warn("There is already an element with short id '" + id + "'. The element may be redefined.");
        }
        this.dataElements.put(id, blob);
        this.submodelElements.put(id, blob);
        return blob;
    }

    @Override
    public BaSyxRelationshipElement register(BaSyxRelationshipElement relationship) {
        String id = relationship.getIdShort();
        this.submodelElements.put(id, relationship);
        return relationship;
    }

    @Override
    public <T extends SubmodelElement> T registerElement(T elt) {
        String id = elt.getIdShort();
        if (this.submodelElements.containsKey(id)) {
            this.warn("There is already a collection/element with short id '" + id + "'. The collection/element may be redefined.");
        }
        this.submodelElements.put(id, elt);
        return elt;
    }

    @Override
    public BaSyxEntity register(BaSyxEntity entity) {
        String id = entity.getIdShort();
        this.submodelElements.put(id, entity);
        return entity;
    }

    @Override
    public BaSyxOperation register(BaSyxOperation operation) {
        String id = operation.getIdShort();
        if (this.operations.containsKey(id) || this.submodelElements.containsKey(id)) {
            this.warn("There is already an operation/element with short id '" + id + "'. The property/element may be redefined.");
        }
        this.operations.put(id, operation);
        this.submodelElements.put(id, operation);
        return operation;
    }

    @Override
    public BaSyxProperty register(BaSyxProperty property) {
        String id = property.getIdShort();
        if (this.properties.containsKey(id) || this.submodelElements.containsKey(id)) {
            this.warn("There is already a property/element with short id '" + id + "'. The property/element may be redefined.");
        }
        this.properties.put(id, property);
        this.submodelElements.put(id, property);
        return property;
    }

    @Override
    public BaSyxMultiLanguageProperty register(BaSyxMultiLanguageProperty property) {
        String id = property.getIdShort();
        if (this.properties.containsKey(id) || this.submodelElements.containsKey(id)) {
            this.warn("There is already a property/element with short id '" + id + "'. The property/element may be redefined.");
        }
        this.dataElements.put(id, (DataElement)property);
        return property;
    }

    @Override
    public BaSyxReferenceElement register(BaSyxReferenceElement reference) {
        String id = reference.getIdShort();
        if (this.submodelElements.containsKey(id)) {
            this.warn("There is already a reference/element with short id '" + id + "'. The reference/element may be redefined.");
        }
        this.submodelElements.put(id, reference);
        return reference;
    }

    @Override
    public BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection) {
        String id = collection.getIdShort();
        if (this.submodelElements.containsKey(id)) {
            this.warn("There is already a collection/element with short id '" + id + "'. The collection/element may be redefined.");
        }
        this.submodelElements.put(id, collection);
        return collection;
    }

    @Override
    public BaSyxSubmodelElementList register(BaSyxSubmodelElementList list) {
        String id = list.getIdShort();
        if (this.submodelElements.containsKey(id)) {
            this.warn("There is already a collection/element with short id '" + id + "'. The collection/element may be redefined.");
        }
        this.submodelElements.put(id, list);
        return list;
    }

    @Override
    public <D extends org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement> BaSyxDataElement<D> register(BaSyxDataElement<D> dataElement) {
        String id = dataElement.getIdShort();
        if (this.dataElements.containsKey(id)) {
            this.warn("There is already a data element with short id '" + id + "'. The data element may be redefined.");
        }
        this.dataElements.put(id, dataElement);
        return dataElement;
    }

    public String getIdShort() {
        return this.submodel.getIdShort();
    }

    public Iterable<SubmodelElement> submodelElements() {
        return this.submodelElements.values();
    }

    public Iterable<Property> properties() {
        return this.properties.values();
    }

    public Iterable<DataElement> dataElements() {
        return this.dataElements.values();
    }

    public Iterable<Operation> operations() {
        return this.operations.values();
    }

    public int getSubmodelElementsCount() {
        return this.submodelElements.size();
    }

    public int getDataElementsCount() {
        return this.dataElements.size();
    }

    public int getOperationsCount() {
        return this.operations.size();
    }

    public DataElement getDataElement(String idShort) {
        return this.dataElements.get(idShort);
    }

    public Property getProperty(String idShort) {
        return this.properties.get(idShort);
    }

    public int getPropertiesCount() {
        return this.properties.size();
    }

    public ReferenceElement getReferenceElement(String idShort) {
        ReferenceElement found = null;
        try {
            SubmodelElement elt = this.submodelElements.get(idShort);
            if (elt instanceof ReferenceElement) {
                found = (ReferenceElement)elt;
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return found;
    }

    public RelationshipElement getRelationshipElement(String idShort) {
        RelationshipElement found = null;
        try {
            SubmodelElement elt = this.submodelElements.get(idShort);
            if (elt instanceof RelationshipElement) {
                found = (RelationshipElement)elt;
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return found;
    }

    public Operation getOperation(String idShort) {
        return this.operations.get(idShort);
    }

    public SubmodelElement getSubmodelElement(String idShort) {
        return this.submodelElements.get(idShort);
    }

    public SubmodelElementCollection getSubmodelElementCollection(String idShort) {
        SubmodelElementCollection result = null;
        SubmodelElement tmp = this.getSubmodelElement(idShort);
        if (tmp instanceof SubmodelElementCollection) {
            result = (SubmodelElementCollection)tmp;
        }
        return result;
    }

    public SubmodelElementList getSubmodelElementList(String idShort) {
        SubmodelElementList result = null;
        SubmodelElement tmp = this.getSubmodelElement(idShort);
        if (tmp instanceof SubmodelElementList) {
            result = (SubmodelElementList)tmp;
        }
        return result;
    }

    public Entity getEntity(String idShort) {
        Entity result = null;
        SubmodelElement tmp = this.getSubmodelElement(idShort);
        if (tmp instanceof Entity) {
            result = (Entity)tmp;
        }
        return result;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitSubmodel((Submodel)this);
        for (Property prop : visitor.sortSubmodelElements(this.properties.values())) {
            prop.accept(visitor);
        }
        for (DataElement de : visitor.sortSubmodelElements(this.dataElements.values())) {
            de.accept(visitor);
        }
        for (Operation op : visitor.sortSubmodelElements(this.operations.values())) {
            op.accept(visitor);
        }
        for (SubmodelElement se : visitor.sortSubmodelElements(this.submodelElements.values())) {
            if (se instanceof Property || se instanceof DataElement || se instanceof Operation) continue;
            se.accept(visitor);
        }
        visitor.endSubmodel((Submodel)this);
    }

    public Reference createReference() {
        return new BaSyxReference(this.getSubmodel().getReference());
    }

    public void deleteElement(SubmodelElement elt) {
        try {
            if (elt instanceof Property) {
                this.properties.remove(elt.getIdShort());
            } else if (elt instanceof DataElement) {
                this.dataElements.remove(elt.getIdShort());
            } else if (elt instanceof Operation) {
                this.operations.remove(elt.getIdShort());
            }
            this.submodelElements.remove(elt.getIdShort());
            this.submodel.deleteSubmodelElement(elt.getIdShort());
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    public void deleteElement(String idShort) {
        try {
            this.properties.remove(idShort);
            this.dataElements.remove(idShort);
            this.operations.remove(idShort);
            this.submodelElements.remove(idShort);
            this.submodel.deleteSubmodelElement(idShort);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    public static String getSubmodelEndpoint(ServerAddress server, Aas aas, Submodel submodel) {
        return AbstractAas.getAasEndpoint(server, aas) + "/submodels/" + Tools.idToUrlPath(submodel.getIdShort()) + "/submodel";
    }

    void defer(String shortId, Builder<?> builder) {
        this.deferred = DeferredBuilder.defer((String)shortId, builder, this.deferred);
    }

    public void buildDeferred() {
        DeferredBuilder.buildDeferred(this.deferred);
    }

    public <B extends Builder<?>> B getDeferred(String shortId, Class<B> cls) {
        return (B)DeferredBuilder.getDeferred((String)shortId, cls, this.deferred);
    }

    public String getIdentification() {
        return Tools.translateIdentifier(this.submodel.getIdentification());
    }

    abstract BaSyxSubmodelParent getAas();

    public String getSemanticId(boolean stripPrefix) {
        return Tools.translateReference(this.submodel.getSemanticId(), stripPrefix);
    }
}

