/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.BlobDataElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDataElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.Blob;

public class BaSyxBlob
extends BaSyxDataElement<Blob>
implements BlobDataElement {
    public BaSyxBlob(String idShort, String value, String mimeType) {
        super(new Blob(idShort, mimeType));
        if (null != value) {
            this.setValue(value);
        }
    }

    public BaSyxBlob(Blob blob) {
        super(blob);
    }

    public String getValue() {
        return ((Blob)this.getDataElement()).getValue();
    }

    public byte[] getValueAsByteArray() {
        return ((Blob)this.getDataElement()).getByteArrayValue();
    }

    public void setValue(String value) {
        ((Blob)this.getDataElement()).setValue(value);
    }

    public void setValue(byte[] value) {
        ((Blob)this.getDataElement()).setByteArrayValue(value);
    }

    public String getMimeType() {
        return ((Blob)this.getDataElement()).getMimeType();
    }

    public void setMimeType(String mimeType) {
        ((Blob)this.getDataElement()).setMimeType(mimeType);
    }

    @Override
    public void accept(AasVisitor visitor) {
        visitor.visitBlobDataElement((BlobDataElement)this);
    }

    public static class BaSyxBlobDataElementBuilder
    implements BlobDataElement.BlobDataElementBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxBlob instance;
        private boolean hasValue = false;

        BaSyxBlobDataElementBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort, String value, String mimeType) {
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxBlob(idShort, value, mimeType);
            this.hasValue = value != null;
        }

        public BlobDataElement.BlobDataElementBuilder setValue(String value) {
            this.hasValue = value != null;
            ((Blob)this.instance.getDataElement()).setValue(value);
            return this;
        }

        public BlobDataElement.BlobDataElementBuilder setValue(byte[] value) {
            this.hasValue = value != null;
            ((Blob)this.instance.getDataElement()).setByteArrayValue(value);
            return this;
        }

        public BlobDataElement.BlobDataElementBuilder setSemanticId(String semanticId) {
            IReference ref = Tools.translateReference(semanticId);
            if (ref != null) {
                ((Blob)this.instance.getDataElement()).setSemanticId(ref);
            }
            return this;
        }

        public BlobDataElement build() {
            if (!this.hasValue) {
                LoggerFactory.getLogger(this.getClass()).warn("Blob data element has null value");
            }
            return this.parentBuilder.register(this.instance);
        }
    }
}

