/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.fileadaptation;

import java.util.Collection;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentSettingSubmodelAggregator
implements ISubmodelAggregator {
    private static Logger logger = LoggerFactory.getLogger(ParentSettingSubmodelAggregator.class);
    private ISubmodelAggregator submodelAggregator;
    private IIdentifier aasIdentifier;

    public ParentSettingSubmodelAggregator(ISubmodelAggregator submodelAggregator, IIdentifier aasIdentifier) {
        this.submodelAggregator = submodelAggregator;
        this.aasIdentifier = aasIdentifier;
    }

    public Collection<ISubmodel> getSubmodelList() {
        return this.submodelAggregator.getSubmodelList();
    }

    public ISubmodel getSubmodel(IIdentifier identifier) throws ResourceNotFoundException {
        return this.submodelAggregator.getSubmodel(identifier);
    }

    public ISubmodel getSubmodelbyIdShort(String idShort) throws ResourceNotFoundException {
        return this.submodelAggregator.getSubmodelbyIdShort(idShort);
    }

    public ISubmodelAPI getSubmodelAPIById(IIdentifier identifier) throws ResourceNotFoundException {
        return this.submodelAggregator.getSubmodelAPIById(identifier);
    }

    public ISubmodelAPI getSubmodelAPIByIdShort(String idShort) throws ResourceNotFoundException {
        return this.submodelAggregator.getSubmodelAPIByIdShort(idShort);
    }

    public void createSubmodel(Submodel submodel) {
        if (!this.parentIsSet(submodel)) {
            ParentSettingSubmodelAggregator.addParentToSubmodel(this.aasIdentifier, submodel);
        }
        this.submodelAggregator.createSubmodel(submodel);
    }

    private boolean parentIsSet(Submodel submodel) {
        return submodel.getParent() != null && submodel.getParent().getKeys() != null && submodel.getParent().getKeys().size() > 0;
    }

    private static void addParentToSubmodel(IIdentifier aasIdentifier, Submodel submodel) {
        submodel.setParent(ParentSettingSubmodelAggregator.getAasReference(aasIdentifier));
        logger.info("Submodel with Identifier " + submodel.getIdentification() + " is missing parent. Setting it to " + submodel.getParent());
    }

    private static IReference getAasReference(IIdentifier aasIdentifier) {
        return new Reference(new Key(KeyElements.ASSETADMINISTRATIONSHELL, false, aasIdentifier.getId(), aasIdentifier.getIdType()));
    }

    public void createSubmodel(ISubmodelAPI submodelAPI) {
        this.submodelAggregator.createSubmodel(submodelAPI);
    }

    public void updateSubmodel(Submodel submodel) throws ResourceNotFoundException {
        this.submodelAggregator.updateSubmodel(submodel);
    }

    public void deleteSubmodelByIdentifier(IIdentifier identifier) {
        this.submodelAggregator.deleteSubmodelByIdentifier(identifier);
    }

    public void deleteSubmodelByIdShort(String idShort) {
        this.submodelAggregator.deleteSubmodelByIdShort(idShort);
    }
}

