/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.authorization.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.servlets.DefaultServlet;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedDefaultServletParams;
import org.eclipse.basyx.components.aas.authorization.internal.IFilesAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.vab.coder.json.metaprotocol.Result;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.protocol.http.server.ExceptionToHTTPCodeMapper;

public class AuthorizedDefaultServlet<SubjectInformationType>
extends DefaultServlet {
    protected final IFilesAuthorizer<SubjectInformationType> filesAuthorizer;
    protected final ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider;

    public AuthorizedDefaultServlet(IFilesAuthorizer<SubjectInformationType> filesAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        this.filesAuthorizer = filesAuthorizer;
        this.subjectInformationProvider = subjectInformationProvider;
    }

    public AuthorizedDefaultServlet(AuthorizedDefaultServletParams<SubjectInformationType> params) {
        this(params.getFilesAuthorizer(), params.getSubjectInformationProvider());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Path path = Paths.get(this.getRelativePath(request, true), new String[0]);
        try {
            this.authorizeDoGet(path);
            super.doGet(request, response);
        }
        catch (NotAuthorizedException e) {
            int httpCode = ExceptionToHTTPCodeMapper.mapFromException((ProviderException)e);
            response.setStatus(httpCode);
            this.sendException((OutputStream)response.getOutputStream(), (Exception)((Object)e));
        }
    }

    protected void authorizeDoGet(Path path) {
        try {
            this.filesAuthorizer.authorizeDownloadFile(this.subjectInformationProvider.get(), path);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException((Exception)((Object)e));
        }
    }

    private void sendException(OutputStream outputStream, Exception e) throws IOException {
        String eString = new GSONTools((GSONToolsFactory)new DefaultTypeFactory()).serialize((Object)new Result(e));
        outputStream.write(eString.getBytes(StandardCharsets.UTF_8));
    }
}

