/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.manager;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.aggregator.AASAggregatorAPIHelper;
import org.eclipse.basyx.aas.aggregator.proxy.AASAggregatorProxy;
import org.eclipse.basyx.aas.manager.api.IAssetAdministrationShellManager;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.connected.ConnectedAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.connected.ConnectedElement;
import org.eclipse.basyx.submodel.metamodel.connected.ConnectedSubmodel;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.factory.java.ModelProxyFactory;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;

public class ConnectedAssetAdministrationShellManager
implements IAssetAdministrationShellManager {
    protected IAASRegistry aasDirectory;
    protected IConnectorFactory connectorFactory;
    protected ModelProxyFactory proxyFactory;

    public ConnectedAssetAdministrationShellManager(IAASRegistry directory) {
        this(directory, new HTTPConnectorFactory());
    }

    public ConnectedAssetAdministrationShellManager(IAASRegistry directory, IConnectorFactory provider) {
        this.aasDirectory = directory;
        this.connectorFactory = provider;
        this.proxyFactory = new ModelProxyFactory(provider);
    }

    @Override
    public ISubmodel retrieveSubmodel(IIdentifier aasId, IIdentifier smId) {
        VABElementProxy proxy = this.getSubmodelProxyFromId(aasId, smId);
        return new ConnectedSubmodel(proxy);
    }

    @Override
    public ConnectedAssetAdministrationShell retrieveAAS(IIdentifier aasId) {
        VABElementProxy proxy = this.getAASProxyFromId(aasId);
        return new ConnectedAssetAdministrationShell(proxy);
    }

    @Override
    public Map<String, ISubmodel> retrieveSubmodels(IIdentifier aasId) {
        AASDescriptor aasDesc = this.aasDirectory.lookupAAS(aasId);
        Collection<SubmodelDescriptor> smDescriptors = aasDesc.getSubmodelDescriptors();
        LinkedHashMap<String, ISubmodel> submodels = new LinkedHashMap<String, ISubmodel>();
        for (SubmodelDescriptor smDesc : smDescriptors) {
            String smIdShort = smDesc.getIdShort();
            ISubmodel connectedSM = this.retrieveSubmodel(aasDesc.getIdentifier(), smDesc.getIdentifier());
            submodels.put(smIdShort, connectedSM);
        }
        return submodels;
    }

    @Override
    public Collection<IAssetAdministrationShell> retrieveAASAll() {
        List<AASDescriptor> aasDescriptors = this.aasDirectory.lookupAll();
        return aasDescriptors.stream().map(d -> this.retrieveAAS(d.getIdentifier())).collect(Collectors.toList());
    }

    @Override
    public void deleteAAS(IIdentifier id) {
        AASDescriptor aasDescriptor = this.aasDirectory.lookupAAS(id);
        String addr = aasDescriptor.getFirstEndpoint();
        String harmonizedAddress = this.getHarmonizedAddress(addr);
        this.aasDirectory.delete(id);
        this.deleteAasFromAddress(harmonizedAddress);
    }

    private void deleteAasFromAddress(String address) {
        this.proxyFactory.createProxy(address).deleteValue("");
    }

    private String getHarmonizedAddress(String address) {
        String strippedAddr = VABPathTools.stripSlashes(address);
        return strippedAddr.substring(0, strippedAddr.length() - "/aas".length());
    }

    @Override
    public void createSubmodel(IIdentifier aasId, Submodel submodel) {
        this.retrieveAAS(aasId).addSubmodel(submodel);
        AASDescriptor aasDescriptor = this.aasDirectory.lookupAAS(aasId);
        String addr = aasDescriptor.getFirstEndpoint();
        String smEndpoint = VABPathTools.concatenatePaths(addr, "submodels", submodel.getIdShort(), "submodel");
        this.aasDirectory.register(aasId, new SubmodelDescriptor(submodel, smEndpoint));
    }

    @Override
    public void deleteSubmodel(IIdentifier aasId, IIdentifier submodelId) {
        ConnectedAssetAdministrationShell shell = this.retrieveAAS(aasId);
        this.aasDirectory.delete(aasId, submodelId);
        shell.removeSubmodel(submodelId);
    }

    @Override
    public void createAAS(AssetAdministrationShell aas, String endpoint) {
        String harmonizedEndpoint = AASAggregatorAPIHelper.harmonizeURL(endpoint);
        IModelProvider provider = this.connectorFactory.create(harmonizedEndpoint);
        AASAggregatorProxy proxy = new AASAggregatorProxy(provider);
        proxy.createAAS(aas);
        String combinedEndpoint = VABPathTools.concatenatePaths(harmonizedEndpoint, AASAggregatorAPIHelper.getAASAccessPath(aas.getIdentification()));
        this.aasDirectory.register(new AASDescriptor(aas, combinedEndpoint));
    }

    private VABElementProxy getAASProxyFromId(IIdentifier aasId) {
        AASDescriptor aasDescriptor = this.aasDirectory.lookupAAS(aasId);
        Optional<Map<String, Object>> optionalAasDescriptor = this.getWorkingAasEndpoint(aasDescriptor.getEndpoints());
        if (!optionalAasDescriptor.isPresent()) {
            throw new ResourceNotFoundException("The resource with id : " + aasId + " could not be found!");
        }
        return this.proxyFactory.createProxy((String)optionalAasDescriptor.get().get("address"));
    }

    private VABElementProxy getSubmodelProxyFromId(IIdentifier aasId, IIdentifier smId) {
        SubmodelDescriptor smDescriptor = this.aasDirectory.lookupSubmodel(aasId, smId);
        Optional<Map<String, Object>> optionalSubmodelDescriptor = this.getWorkingSubmodelEndpoint(smDescriptor.getEndpoints());
        if (!optionalSubmodelDescriptor.isPresent()) {
            throw new ResourceNotFoundException("The resource with id : " + aasId + " could not be found!");
        }
        return this.proxyFactory.createProxy((String)optionalSubmodelDescriptor.get().get("address"));
    }

    private Optional<Map<String, Object>> getWorkingAasEndpoint(Collection<Map<String, Object>> endpoints) {
        return endpoints.stream().filter(endpoint -> this.isWorking(new ConnectedAssetAdministrationShell(this.createProxy((Map<String, Object>)endpoint)))).findFirst();
    }

    private Optional<Map<String, Object>> getWorkingSubmodelEndpoint(Collection<Map<String, Object>> endpoints) {
        return endpoints.stream().filter(endpoint -> this.isWorking(new ConnectedSubmodel(this.createProxy((Map<String, Object>)endpoint)))).findFirst();
    }

    private VABElementProxy createProxy(Map<String, Object> endpoint) {
        return this.proxyFactory.createProxy((String)endpoint.get("address"));
    }

    private boolean isWorking(ConnectedElement connectedElement) {
        try {
            this.attemptIdentificationRetrieval(connectedElement);
            return true;
        }
        catch (ProviderException e) {
            return false;
        }
    }

    private void attemptIdentificationRetrieval(ConnectedElement connectedElement) {
        if (connectedElement instanceof ConnectedAssetAdministrationShell) {
            ((ConnectedAssetAdministrationShell)connectedElement).getIdentification();
        } else {
            ((ConnectedSubmodel)connectedElement).getIdentification();
        }
    }
}

