/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.registration.memory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.memory.IRegistryHandler;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASRegistry
implements IAASRegistry {
    private static Logger logger = LoggerFactory.getLogger(AASRegistry.class);
    protected IRegistryHandler handler;

    public AASRegistry(IRegistryHandler handler) {
        this.handler = handler;
    }

    @Override
    public void register(AASDescriptor aasDescriptor) {
        IIdentifier aasIdentifier = aasDescriptor.getIdentifier();
        if (this.handler.contains(aasIdentifier)) {
            this.handler.update(aasDescriptor);
        } else {
            this.handler.insert(aasDescriptor);
        }
        logger.debug("Registered " + aasIdentifier.getId());
    }

    @Override
    public void delete(IIdentifier aasIdentifier) {
        String aasId = aasIdentifier.getId();
        if (!this.handler.contains(aasIdentifier)) {
            throw new ResourceNotFoundException("Could not delete key for AAS " + aasId + " since it does not exist");
        }
        this.handler.remove(aasIdentifier);
        logger.debug("Removed " + aasId);
    }

    @Override
    public AASDescriptor lookupAAS(IIdentifier aasIdentifier) {
        String aasId = aasIdentifier.getId();
        if (!this.handler.contains(aasIdentifier)) {
            throw new ResourceNotFoundException("Could not look up descriptor for AAS " + aasId + " since it does not exist");
        }
        return this.handler.get(aasIdentifier);
    }

    @Override
    public List<AASDescriptor> lookupAll() {
        logger.debug("Looking up all AAS");
        return this.handler.getAll();
    }

    @Override
    public void register(IIdentifier aas, SubmodelDescriptor smDescriptor) {
        try {
            this.delete(aas, smDescriptor.getIdentifier());
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        AASDescriptor descriptor = this.handler.get(aas);
        if (descriptor == null) {
            throw new ResourceNotFoundException("Could not add submodel descriptor for AAS " + aas.getId() + " since the AAS does not exist");
        }
        descriptor.addSubmodelDescriptor(smDescriptor);
        this.handler.update(descriptor);
        logger.debug("Registered submodel " + smDescriptor.getIdShort() + " for AAS " + aas.getId());
    }

    @Override
    public void delete(IIdentifier aasId, IIdentifier smId) {
        String smIdString = smId.getId();
        AASDescriptor desc = this.handler.get(aasId);
        if (desc == null) {
            throw new ResourceNotFoundException("Could not delete submodel descriptor for AAS " + aasId.getId() + " since the AAS does not exist");
        }
        if (desc.getSubmodelDescriptorFromIdentifierId(smIdString) == null) {
            throw new ResourceNotFoundException("Could not delete submodel descriptor for AAS " + aasId.getId() + " since the SM does not exist");
        }
        desc.removeSubmodelDescriptor(smId);
        this.handler.update(desc);
        logger.debug("Deleted submodel " + smIdString + " from AAS " + aasId.getId());
    }

    @Override
    public List<SubmodelDescriptor> lookupSubmodels(IIdentifier aasId) throws ProviderException {
        AASDescriptor desc = this.handler.get(aasId);
        if (desc == null) {
            throw new ResourceNotFoundException("Could not look up submodels for AAS " + aasId + " since it does not exist");
        }
        return new ArrayList<SubmodelDescriptor>(desc.getSubmodelDescriptors());
    }

    @Override
    public SubmodelDescriptor lookupSubmodel(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        AASDescriptor desc = this.handler.get(aasId);
        if (desc == null) {
            throw new ResourceNotFoundException("Could not look up descriptor for SM " + smId + " of AAS " + aasId + " since the AAS does not exist");
        }
        SubmodelDescriptor smDesc = desc.getSubmodelDescriptorFromIdentifierId(smId.getId());
        if (smDesc == null) {
            throw new ResourceNotFoundException("Could not look up descriptor for SM " + smId + " of AAS " + aasId + " since the SM does not exist");
        }
        return smDesc;
    }
}

