/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.aasxupload.restapi;

import java.io.InputStream;
import org.eclipse.basyx.aas.aggregator.restapi.AASAggregatorProvider;
import org.eclipse.basyx.extensions.aas.aggregator.aasxupload.api.IAASAggregatorAASXUpload;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;

public class AASAggregatorAASXUploadProvider
extends AASAggregatorProvider {
    private IAASAggregatorAASXUpload uploadAggregator;
    public static final String AASX_PATH = "aasx";

    public AASAggregatorAASXUploadProvider(IAASAggregatorAASXUpload aggregator) {
        super(aggregator);
        this.uploadAggregator = aggregator;
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        String strippedPath = this.stripPrefix(path);
        String[] splitted = VABPathTools.splitPath(strippedPath);
        if (this.isAASXAccessPath(splitted)) {
            try {
                this.uploadAggregator.uploadAASX((InputStream)newEntity);
            }
            catch (Exception e) {
                throw new ProviderException("AASX upload failed");
            }
        } else {
            super.createValue(path, newEntity);
        }
    }

    private boolean isAASXAccessPath(String[] splitted) {
        return splitted.length == 1 && splitted[0].equals(AASX_PATH);
    }
}

