/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.mqtt;

import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregatorFactory;
import org.eclipse.basyx.aas.aggregator.observing.ObservableAASAggregator;
import org.eclipse.basyx.extensions.aas.aggregator.mqtt.MqttAASAggregatorObserver;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttDecoratingAASAggregatorFactory
implements IAASAggregatorFactory {
    private IAASAggregatorFactory apiFactory;
    private MqttClient client;

    public MqttDecoratingAASAggregatorFactory(IAASAggregatorFactory factoryToBeDecorated, MqttClient client) {
        this.apiFactory = factoryToBeDecorated;
        this.client = client;
    }

    @Override
    public IAASAggregator create() {
        try {
            IAASAggregator aggregator = this.apiFactory.create();
            ObservableAASAggregator observedAASAggregator = new ObservableAASAggregator(aggregator);
            MqttAASAggregatorObserver observer = new MqttAASAggregatorObserver(this.client);
            observedAASAggregator.addObserver(observer);
            return observedAASAggregator;
        }
        catch (MqttException exception) {
            throw new ProviderException(exception);
        }
    }
}

