/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.registration.authorization.internal;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.extensions.aas.registration.authorization.internal.IAASRegistryAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.IdHelper;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.SimpleRbacHelper;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;

public class SimpleRbacAASRegistryAuthorizer<SubjectInformationType>
implements IAASRegistryAuthorizer<SubjectInformationType> {
    protected IRbacRuleChecker rbacRuleChecker;
    protected IRoleAuthenticator<SubjectInformationType> roleAuthenticator;

    public SimpleRbacAASRegistryAuthorizer(IRbacRuleChecker rbacRuleChecker, IRoleAuthenticator<SubjectInformationType> roleAuthenticator) {
        this.rbacRuleChecker = rbacRuleChecker;
        this.roleAuthenticator = roleAuthenticator;
    }

    @Override
    public void authorizeRegisterAas(SubjectInformationType subjectInformation, IIdentifier aasId, AASDescriptor aasDescriptor) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null, null));
    }

    @Override
    public void authorizeRegisterSubmodel(SubjectInformationType subjectInformation, IIdentifier aasId, IIdentifier smId, IReference smSemanticId, SubmodelDescriptor smDescriptor) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), null));
    }

    @Override
    public void authorizeUnregisterAas(SubjectInformationType subjectInformation, IIdentifier aasId) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null, null));
    }

    @Override
    public void authorizeUnregisterSubmodel(SubjectInformationType subjectInformation, IIdentifier aasId, IIdentifier smId, IReference smSemanticId) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), null));
    }

    @Override
    public AASDescriptor authorizeLookupAAS(SubjectInformationType subjectInformation, IIdentifier aasId, Supplier<AASDescriptor> aasSupplier) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null, null));
        return aasSupplier.get();
    }

    @Override
    public List<AASDescriptor> authorizeLookupAll(SubjectInformationType subjectInformation, Supplier<List<AASDescriptor>> aasDescriptorsSupplier) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:read", new BaSyxObjectTargetInformation(null, null, null, null));
        return aasDescriptorsSupplier.get();
    }

    @Override
    public List<SubmodelDescriptor> authorizeLookupSubmodels(SubjectInformationType subjectInformation, IIdentifier aasId, Supplier<List<SubmodelDescriptor>> submodelDescriptorsSupplier) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null, null));
        return submodelDescriptorsSupplier.get();
    }

    @Override
    public SubmodelDescriptor authorizeLookupSubmodel(SubjectInformationType subjectInformation, IIdentifier aasId, IIdentifier smId, IReference smSemanticId, Supplier<SubmodelDescriptor> smSupplier) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), null));
        return smSupplier.get();
    }
}

