/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.registration.mqtt;

import org.eclipse.basyx.aas.registration.observing.IAASRegistryServiceObserver;
import org.eclipse.basyx.extensions.aas.registration.mqtt.MqttAASRegistryHelper;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttAASRegistryServiceObserver
extends MqttEventService
implements IAASRegistryServiceObserver {
    private static Logger logger = LoggerFactory.getLogger(MqttAASRegistryServiceObserver.class);

    public MqttAASRegistryServiceObserver(String serverEndpoint, String clientId) throws MqttException {
        super(serverEndpoint, clientId);
        logger.info("Create new MQTT AAS Registry Service Observer for endpoint " + serverEndpoint);
    }

    public MqttAASRegistryServiceObserver(String serverEndpoint, String clientId, MqttClientPersistence mqttPersistence) throws MqttException {
        super(serverEndpoint, clientId, mqttPersistence);
        logger.info("Create new MQTT AAS Registry Service Observer for endpoint " + serverEndpoint);
    }

    public MqttAASRegistryServiceObserver(String serverEndpoint, String clientId, String user, char[] pw, MqttClientPersistence mqttPersistence) throws MqttException {
        super(serverEndpoint, clientId, user, pw, mqttPersistence);
    }

    public MqttAASRegistryServiceObserver(String serverEndpoint, String clientId, String user, char[] pw) throws MqttException {
        super(serverEndpoint, clientId, user, pw);
        logger.info("Create new MQTT AAS Registry Service Observer for endpoint " + serverEndpoint);
    }

    public MqttAASRegistryServiceObserver(MqttClient client) throws MqttException {
        super(client);
        logger.info("Create new MQTT AAS Registry Service Observer for endpoint " + client.getServerURI());
    }

    @Override
    public void aasRegistered(String aasId) {
        this.sendMqttMessage("BaSyxRegistry_registeredAAS", aasId);
    }

    @Override
    public void submodelRegistered(IIdentifier aasId, IIdentifier smId) {
        this.sendMqttMessage("BaSyxRegistry_registeredSubmodel", MqttAASRegistryHelper.createSubmodelDescriptorOfAASChangedPayload(aasId, smId));
    }

    @Override
    public void aasDeleted(String aasId) {
        this.sendMqttMessage("BaSyxRegistry_deletedAAS", MqttAASRegistryHelper.createRegisteredAASChangedPayload(aasId));
    }

    @Override
    public void submodelDeleted(IIdentifier aasId, IIdentifier smId) {
        this.sendMqttMessage("BaSyxRegistry_deletedSubmodel", MqttAASRegistryHelper.createSubmodelDescriptorOfAASChangedPayload(aasId, smId));
    }
}

