/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.internal.storage;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelDescriptor;
import org.eclipse.basyx.extensions.internal.storage.IBaSyxStorageAPI;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaSyxStorageAPI<T>
implements IBaSyxStorageAPI<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String COLLECTION_NAME;
    protected final Class<T> TYPE;

    BaSyxStorageAPI() {
        this(null, null);
    }

    public BaSyxStorageAPI(String collectionName, Class<T> type) {
        this.COLLECTION_NAME = collectionName;
        this.TYPE = type;
    }

    protected String getKey(T obj) {
        if (!(obj instanceof IIdentifiable) && !(obj instanceof ModelDescriptor)) {
            throw new IllegalArgumentException("Can only extract a key from a object of types " + IIdentifiable.class.getName() + " or " + ModelDescriptor.class.getName());
        }
        if (obj instanceof ModelDescriptor) {
            return ((ModelDescriptor)obj).getIdentifier().getId();
        }
        return ((IIdentifiable)obj).getIdentification().getId();
    }

    public abstract T rawRetrieve(String var1);

    public abstract Collection<T> rawRetrieveAll();

    public abstract File getFile(String var1, String var2, Map<String, Object> var3);

    public abstract String writeFile(String var1, String var2, InputStream var3, ISubmodelElement var4);

    public abstract void deleteFile(Submodel var1, String var2);

    public abstract Object getStorageConnection();

    @Override
    public T retrieve(String key) {
        T retrieved = this.rawRetrieve(key);
        if (retrieved != null && this.isSubmodelType(retrieved.getClass())) {
            return (T)this.handleRetrievedSubmodel((Submodel)retrieved);
        }
        return retrieved;
    }

    @Override
    public Collection<T> retrieveAll() {
        Collection<T> retrieves = this.rawRetrieveAll();
        if (!CollectionUtils.isEmpty(retrieves) && this.isSubmodelType(this.getElementClass(retrieves))) {
            return retrieves.stream().map(submodel -> this.handleRetrievedSubmodel((Submodel)submodel)).collect(Collectors.toList());
        }
        return retrieves;
    }

    private Class<? extends Object> getElementClass(Collection<T> collection) {
        return collection.iterator().next().getClass();
    }

    protected Submodel handleRetrievedSubmodel(Submodel retrieved) {
        Map elementMaps = (Map)retrieved.get("submodelElements");
        Map<String, ISubmodelElement> elements = this.enforceISubmodelElements(elementMaps);
        retrieved.put("submodelElements", elements);
        return retrieved;
    }

    private Map<String, ISubmodelElement> enforceISubmodelElements(Map<String, Map<String, Object>> submodelElementObjectMap) {
        HashMap<String, ISubmodelElement> elements = new HashMap<String, ISubmodelElement>();
        submodelElementObjectMap.forEach((idShort, elementMap) -> {
            ISubmodelElement element = SubmodelElementFacadeFactory.createSubmodelElement(elementMap);
            elements.put((String)idShort, element);
        });
        return elements;
    }

    protected boolean isSubmodelType(Class<?> type) {
        return ISubmodel.class.isAssignableFrom(type);
    }

    protected boolean isShellType(Class<?> type) {
        return IAssetAdministrationShell.class.isAssignableFrom(type);
    }

    protected boolean isAASDescriptorType(Class<?> type) {
        return AASDescriptor.class.isAssignableFrom(type);
    }

    protected boolean isBaSyxType(Class<?> type) {
        return this.isShellType(type) || this.isSubmodelType(type) || this.isAASDescriptorType(type);
    }

    public String getCollectionName() {
        return this.COLLECTION_NAME;
    }
}

