/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.mqtt;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.extensions.submodel.mqtt.MqttSubmodelAPIHelper;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.restapi.observing.ISubmodelAPIObserver;
import org.eclipse.basyx.submodel.restapi.observing.ObservableSubmodelAPI;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSubmodelAPIObserver
extends MqttEventService
implements ISubmodelAPIObserver {
    private static Logger logger = LoggerFactory.getLogger(MqttSubmodelAPIObserver.class);
    protected boolean useWhitelist = false;
    protected Set<String> whitelist = new HashSet<String>();
    private IIdentifier aasIdentifier;
    private IIdentifier submodelIdentifier;

    public MqttSubmodelAPIObserver(MqttClient client, IIdentifier aasId, IIdentifier submodelIdentifier) throws MqttException {
        super(client);
        this.connectMqttClientIfRequired();
        this.aasIdentifier = aasId;
        this.submodelIdentifier = submodelIdentifier;
        this.sendMqttMessage("BaSyxSubmodel_createdSubmodel", MqttSubmodelAPIHelper.createChangedSubmodelPayload(this.submodelIdentifier.getId()));
    }

    public MqttSubmodelAPIObserver(MqttClient client, IIdentifier aasId, IIdentifier submodelIdentifier, MqttConnectOptions options) throws MqttException {
        super(client);
        this.connectMqttClientIfRequired(options);
        this.aasIdentifier = aasId;
        this.submodelIdentifier = submodelIdentifier;
        this.sendMqttMessage("BaSyxSubmodel_createdSubmodel", MqttSubmodelAPIHelper.createChangedSubmodelPayload(this.submodelIdentifier.getId()));
    }

    @Deprecated
    public MqttSubmodelAPIObserver(ObservableSubmodelAPI observedAPI, String serverEndpoint, String clientId) throws MqttException {
        this(observedAPI, serverEndpoint, clientId, (MqttClientPersistence)new MqttDefaultFilePersistence());
    }

    @Deprecated
    public MqttSubmodelAPIObserver(ObservableSubmodelAPI observedAPI, String brokerEndpoint, String clientId, MqttClientPersistence persistence) throws MqttException {
        this(new MqttClient(brokerEndpoint, clientId, persistence), MqttSubmodelAPIHelper.getAASId(observedAPI), MqttSubmodelAPIHelper.getSubmodelId(observedAPI));
        logger.info("Create new MQTT submodel for endpoint " + brokerEndpoint);
        observedAPI.addObserver(this);
        this.sendMqttMessage("BaSyxSubmodel_createdSubmodel", MqttSubmodelAPIHelper.createChangedSubmodelPayload(this.submodelIdentifier.getId()));
    }

    @Deprecated
    public MqttSubmodelAPIObserver(ObservableSubmodelAPI observedAPI, String serverEndpoint, String clientId, String user, char[] pw) throws MqttException {
        this(observedAPI, serverEndpoint, clientId, user, pw, (MqttClientPersistence)new MqttDefaultFilePersistence());
    }

    @Deprecated
    public MqttSubmodelAPIObserver(ObservableSubmodelAPI observedAPI, String serverEndpoint, String clientId, String user, char[] pw, MqttClientPersistence persistence) throws MqttException {
        this(new MqttClient(serverEndpoint, clientId, persistence), MqttSubmodelAPIHelper.getAASId(observedAPI), MqttSubmodelAPIHelper.getSubmodelId(observedAPI), MqttSubmodelAPIHelper.getMqttConnectOptions(user, pw));
        logger.info("Create new MQTT submodel for endpoint " + serverEndpoint);
        observedAPI.addObserver(this);
        this.sendMqttMessage("BaSyxSubmodel_createdSubmodel", MqttSubmodelAPIHelper.createChangedSubmodelPayload(this.submodelIdentifier.getId()));
    }

    @Deprecated
    public MqttSubmodelAPIObserver(ObservableSubmodelAPI observedAPI, MqttClient client) throws MqttException {
        this(client, MqttSubmodelAPIHelper.getAASId(observedAPI), MqttSubmodelAPIHelper.getSubmodelId(observedAPI));
        observedAPI.addObserver(this);
        this.sendMqttMessage("BaSyxSubmodel_createdSubmodel", MqttSubmodelAPIHelper.createChangedSubmodelPayload(this.submodelIdentifier.getId()));
    }

    private void connectMqttClientIfRequired() throws MqttException {
        if (!this.mqttClient.isConnected()) {
            this.mqttClient.connect();
        }
    }

    private void connectMqttClientIfRequired(MqttConnectOptions options) throws MqttException {
        if (!this.mqttClient.isConnected()) {
            this.mqttClient.connect(options);
        }
    }

    public void observeSubmodelElement(String shortId) {
        this.whitelist.add(VABPathTools.stripSlashes(shortId));
    }

    public void setWhitelist(Set<String> shortIds) {
        this.whitelist.clear();
        for (String entry : shortIds) {
            this.whitelist.add(VABPathTools.stripSlashes(entry));
        }
    }

    public void disableWhitelist() {
        this.useWhitelist = false;
    }

    public void enableWhitelist() {
        this.useWhitelist = true;
    }

    @Override
    public void elementAdded(String idShortPath, Object newValue) {
        if (this.filter(idShortPath)) {
            this.sendMqttMessage("BaSyxSubmodel_addedSubmodelElement", MqttSubmodelAPIHelper.createChangedSubmodelElementPayload(this.getParentIdIfPresent(), this.submodelIdentifier.getId(), idShortPath));
        }
    }

    @Override
    public void elementDeleted(String idShortPath) {
        if (this.filter(idShortPath)) {
            this.sendMqttMessage("BaSyxSubmodel_removedSubmodelElement", MqttSubmodelAPIHelper.createChangedSubmodelElementPayload(this.getParentIdIfPresent(), this.submodelIdentifier.getId(), idShortPath));
        }
    }

    @Override
    public void elementUpdated(String idShortPath, Object newValue) {
        if (this.filter(idShortPath)) {
            this.sendMqttMessage("BaSyxSubmodel_updatedSubmodelElement", MqttSubmodelAPIHelper.createChangedSubmodelElementPayload(this.getParentIdIfPresent(), this.submodelIdentifier.getId(), idShortPath));
        }
    }

    @Deprecated
    public static String getCombinedMessage(String aasId, String submodelId, String elementPart) {
        elementPart = VABPathTools.stripSlashes(elementPart);
        return "(" + aasId + "," + submodelId + "," + elementPart + ")";
    }

    private boolean filter(String idShort) {
        idShort = VABPathTools.stripSlashes(idShort);
        return !this.useWhitelist || this.whitelist.contains(idShort);
    }

    private String getParentIdIfPresent() {
        return this.aasIdentifier == null ? null : this.aasIdentifier.getId();
    }
}

