/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueTypeHelper;

public class XMLHelper {
    public static final String TEXT = "#text";

    public static List<Map<String, Object>> getList(Object xmlObject) {
        if (xmlObject instanceof List) {
            return (List)xmlObject;
        }
        if (xmlObject instanceof Map) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            list.add((Map)xmlObject);
            return list;
        }
        return new ArrayList<Map<String, Object>>();
    }

    public static String getString(Object object) {
        if (object == null || object instanceof Map) {
            return "";
        }
        return object.toString().trim();
    }

    public static ValueType convertAASXValueTypeToLocal(String valueType) {
        if (Strings.isNullOrEmpty((String)valueType)) {
            return ValueType.AnySimpleType;
        }
        if (valueType.equals("anyURI")) {
            return ValueType.AnyURI;
        }
        if (valueType.equals("date")) {
            return ValueType.DateTime;
        }
        if (valueType.equals("decimal")) {
            return ValueType.Double;
        }
        return ValueTypeHelper.fromName(valueType);
    }

    public static Object convertAASXValueToLocal(String xmlStringValue, ValueType valueType) {
        switch (valueType) {
            case Boolean: {
                return XMLHelper.verifiedBoolean(xmlStringValue);
            }
            case Double: {
                return XMLHelper.verifiedDecimal(xmlStringValue);
            }
            case Integer: {
                return XMLHelper.verifiedInt(xmlStringValue);
            }
        }
        return xmlStringValue;
    }

    private static Boolean verifiedBoolean(String booleanString) {
        if (XMLHelper.isStringNullOrEmpty(booleanString)) {
            return null;
        }
        if (!XMLHelper.isLegalBooleanString(booleanString)) {
            throw new IllegalArgumentException(String.format("The passed value '" + booleanString + "' is not compatible with type Boolean", booleanString));
        }
        return Boolean.parseBoolean(booleanString);
    }

    private static Double verifiedDecimal(String decimalString) {
        if (XMLHelper.isStringNullOrEmpty(decimalString)) {
            return null;
        }
        try {
            return Double.parseDouble(decimalString);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("The passed value '" + decimalString + "' is no compatible decimal type", decimalString));
        }
    }

    private static Integer verifiedInt(String intString) {
        if (XMLHelper.isStringNullOrEmpty(intString)) {
            return null;
        }
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("The passed value '" + intString + "' is not compatible with type Integer", intString));
        }
    }

    private static boolean isLegalBooleanString(String booleanString) {
        return booleanString.equalsIgnoreCase("true") || booleanString.equalsIgnoreCase("false") || booleanString.equalsIgnoreCase("1") || booleanString.equalsIgnoreCase("0");
    }

    private static boolean isStringNullOrEmpty(String decimalString) {
        return decimalString.isEmpty() || decimalString == null;
    }
}

