/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.connected.submodelelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IDataElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.ConnectedCapability;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.ConnectedSubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement.ConnectedBlob;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement.ConnectedFile;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement.ConnectedMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement.ConnectedProperty;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement.ConnectedRange;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.dataelement.ConnectedReferenceElement;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.entity.ConnectedEntity;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.event.ConnectedBasicEvent;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.operation.ConnectedOperation;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.relationship.ConnectedAnnotatedRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.relationship.ConnectedRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.Capability;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.Blob;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.ReferenceElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.range.Range;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.event.BasicEvent;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.AnnotatedRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElement;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;

public class ConnectedSubmodelElementFactory {
    public static Map<String, ISubmodelElement> getConnectedSubmodelElements(VABElementProxy rootProxy, String collectionPath, String elementPath) {
        Collection mapElemList = (Collection)rootProxy.getValue(collectionPath);
        LinkedHashMap<String, ISubmodelElement> ret = new LinkedHashMap<String, ISubmodelElement>();
        for (Map node : mapElemList) {
            String idShort = Referable.createAsFacade(node, KeyElements.SUBMODELELEMENT).getIdShort();
            ISubmodelElement element = ConnectedSubmodelElementFactory.getConnectedSubmodelElement(rootProxy, elementPath, idShort, node);
            ret.put(idShort, element);
        }
        return ret;
    }

    public static Collection<ISubmodelElement> getElementCollection(VABElementProxy rootProxy, String collectionPath, String elementPath) {
        Collection mapElemList = (Collection)rootProxy.getValue(collectionPath);
        ArrayList<ISubmodelElement> ret = new ArrayList<ISubmodelElement>();
        for (Map node : mapElemList) {
            String idShort = Referable.createAsFacade(node, KeyElements.SUBMODELELEMENT).getIdShort();
            ISubmodelElement element = ConnectedSubmodelElementFactory.getConnectedSubmodelElement(rootProxy, elementPath, idShort, node);
            ret.add(element);
        }
        return ret;
    }

    public static ISubmodelElement getConnectedSubmodelElement(VABElementProxy rootProxy, String elementPath, String idShort, Map<String, Object> mapContent) {
        String subPath = VABPathTools.concatenatePaths(elementPath, idShort);
        VABElementProxy proxy = rootProxy.getDeepProxy(subPath);
        if (Property.isProperty(mapContent)) {
            return new ConnectedProperty(proxy);
        }
        if (Blob.isBlob(mapContent)) {
            return new ConnectedBlob(proxy);
        }
        if (File.isFile(mapContent)) {
            return new ConnectedFile(proxy);
        }
        if (SubmodelElementCollection.isSubmodelElementCollection(mapContent)) {
            return new ConnectedSubmodelElementCollection(proxy);
        }
        if (MultiLanguageProperty.isMultiLanguageProperty(mapContent)) {
            return new ConnectedMultiLanguageProperty(proxy);
        }
        if (Range.isRange(mapContent)) {
            return new ConnectedRange(proxy);
        }
        if (ReferenceElement.isReferenceElement(mapContent)) {
            return new ConnectedReferenceElement(proxy);
        }
        if (AnnotatedRelationshipElement.isAnnotatedRelationshipElement(mapContent)) {
            return new ConnectedAnnotatedRelationshipElement(proxy);
        }
        if (RelationshipElement.isRelationshipElement(mapContent)) {
            return new ConnectedRelationshipElement(proxy);
        }
        if (Operation.isOperation(mapContent)) {
            return new ConnectedOperation(proxy);
        }
        if (BasicEvent.isBasicEvent(mapContent)) {
            return new ConnectedBasicEvent(proxy);
        }
        if (Capability.isCapability(mapContent)) {
            return new ConnectedCapability(proxy);
        }
        if (Entity.isEntity(mapContent)) {
            return new ConnectedEntity(proxy);
        }
        return null;
    }

    public static Map<String, IOperation> getOperations(VABElementProxy rootProxy, String collectionPath, String elementPath) {
        Collection mapElemList = (Collection)rootProxy.getValue(collectionPath);
        LinkedHashMap<String, IOperation> ret = new LinkedHashMap<String, IOperation>();
        for (Map node : mapElemList) {
            String idShort = Referable.createAsFacade(node, KeyElements.OPERATION).getIdShort();
            String subPath = VABPathTools.concatenatePaths(elementPath, idShort);
            VABElementProxy proxy = rootProxy.getDeepProxy(subPath);
            if (!Operation.isOperation(node)) continue;
            ret.put(idShort, new ConnectedOperation(proxy));
        }
        return ret;
    }

    public static Map<String, IDataElement> getDataElements(VABElementProxy rootProxy, String collectionPath, String elementPath) {
        Collection mapElemList = (Collection)rootProxy.getValue(collectionPath);
        LinkedHashMap<String, IDataElement> ret = new LinkedHashMap<String, IDataElement>();
        for (Map node : mapElemList) {
            String idShort = Referable.createAsFacade(node, KeyElements.DATAELEMENT).getIdShort();
            String subPath = VABPathTools.concatenatePaths(elementPath, idShort);
            VABElementProxy proxy = rootProxy.getDeepProxy(subPath);
            if (Property.isProperty(node)) {
                ret.put(idShort, new ConnectedProperty(proxy));
                continue;
            }
            if (Blob.isBlob(node)) {
                ret.put(idShort, new ConnectedBlob(proxy));
                continue;
            }
            if (File.isFile(node)) {
                ret.put(idShort, new ConnectedFile(proxy));
                continue;
            }
            if (MultiLanguageProperty.isMultiLanguageProperty(node)) {
                ret.put(idShort, new ConnectedMultiLanguageProperty(proxy));
                continue;
            }
            if (Range.isRange(node)) {
                ret.put(idShort, new ConnectedRange(proxy));
                continue;
            }
            if (!ReferenceElement.isReferenceElement(node)) continue;
            ret.put(idShort, new ConnectedReferenceElement(proxy));
        }
        return ret;
    }

    public static Map<String, IProperty> getProperties(VABElementProxy rootProxy, String collectionPath, String elementPath) {
        Collection mapElemList = (Collection)rootProxy.getValue(collectionPath);
        LinkedHashMap<String, IProperty> ret = new LinkedHashMap<String, IProperty>();
        for (Map node : mapElemList) {
            String idShort = Referable.createAsFacade(node, KeyElements.DATAELEMENT).getIdShort();
            String subPath = VABPathTools.concatenatePaths(elementPath, idShort);
            VABElementProxy proxy = rootProxy.getDeepProxy(subPath);
            if (!Property.isProperty(node)) continue;
            ret.put(idShort, new ConnectedProperty(proxy));
        }
        return ret;
    }
}

