/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.modelprovider.filesystem;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceAlreadyExistsException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.filesystem.filesystem.File;
import org.eclipse.basyx.vab.modelprovider.filesystem.filesystem.FileSystem;
import org.eclipse.basyx.vab.modelprovider.filesystem.filesystem.FileType;

public class FileSystemProvider
implements IModelProvider {
    private final FileSystem fileSystem;
    private final String rootDir;
    private final String collectionElemPrefix = "byRef_";
    private final String metaFileName = "_meta";
    private final String referenceFileName = "references";
    private final String regexCollectionElem = "byRef_(0|[1-9][0-9]*)";
    private final GSONTools tools = new GSONTools(new DefaultTypeFactory());

    public FileSystemProvider(FileSystem fileSystem, String rootDir) throws ProviderException {
        this.fileSystem = fileSystem;
        this.rootDir = this.unifyPath(rootDir);
        this.createDirectory(rootDir + "/");
    }

    public FileSystemProvider(FileSystem fileSystem, String rootDir, Map<String, Object> VABelement) throws ProviderException {
        this.fileSystem = fileSystem;
        this.rootDir = this.unifyPath(rootDir);
        this.createDirectory(rootDir + "/");
        this.fromMapToDirectory("", VABelement);
    }

    public FileSystemProvider(FileSystem fileSystem, String rootDir, Map<String, Object> VABelement, boolean doEmptyDirectory) throws ProviderException {
        this.fileSystem = fileSystem;
        this.rootDir = this.unifyPath(rootDir);
        this.createDirectory(rootDir + "/");
        if (doEmptyDirectory) {
            this.deleteDirectory(rootDir);
        }
        this.fromMapToDirectory("", VABelement);
    }

    private String unifyPath(String path) throws MalformedRequestException {
        VABPathTools.checkPathForNull(path);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private String constructCollectionRefPath(String path, int ref) {
        return path + "/byRef_" + ref;
    }

    private HashSet<String> readMetaFile(String path) throws ProviderException {
        Object object = path = ((String)path).equals("") ? this.rootDir + "/_meta" : this.rootDir + "/" + (String)path + "/_meta";
        if (this.fileSystem.getType((String)path) == FileType.DATA) {
            Object deserialized = this.loadAndDeserialize((String)path);
            if (deserialized instanceof HashSet) {
                return (HashSet)deserialized;
            }
            if (deserialized instanceof Collection) {
                return new HashSet<String>((List)deserialized);
            }
        }
        return null;
    }

    private File findFileInList(List<File> files, String fileName) {
        if (fileName.equals("")) {
            return new File(this.rootDir, FileType.DIRECTORY);
        }
        for (File file : files) {
            String currentFileName = VABPathTools.getLastElement(file.getName());
            if (!currentFileName.equals(fileName)) continue;
            return file;
        }
        return null;
    }

    private Collection<Object> readCollection(String path) throws ProviderException {
        ArrayList<Object> c = new ArrayList<Object>();
        String fullPath = this.rootDir + "/" + path;
        for (int ref : this.readReferences(fullPath)) {
            FileType type = this.fileSystem.getType(this.constructCollectionRefPath(fullPath, ref));
            if (type == FileType.DATA) {
                c.add(this.loadAndDeserialize(this.constructCollectionRefPath(fullPath, ref)));
                continue;
            }
            if (type != FileType.DIRECTORY) continue;
            c.add(this.readDirectory(this.constructCollectionRefPath(path, ref)));
        }
        return c;
    }

    private LinkedHashMap<String, Object> readDirectory(String path) throws ProviderException {
        List<File> directoryFiles;
        String fullPath = this.rootDir + "/" + path;
        LinkedHashMap<String, Object> returnData = new LinkedHashMap<String, Object>();
        HashSet<String> collections = this.readMetaFile(path);
        try {
            directoryFiles = this.fileSystem.readDirectory(fullPath);
        }
        catch (IOException e) {
            throw new ProviderException("Path \"" + path + "\" could not be read.");
        }
        this.removeMetaFile(directoryFiles);
        for (File file : directoryFiles) {
            String currentFilePath = file.getName();
            String fileName = VABPathTools.getLastElement(currentFilePath);
            if (file.getType() == FileType.DATA) {
                returnData.put(fileName, this.loadAndDeserialize(currentFilePath));
                continue;
            }
            if (collections != null && collections.contains(fileName)) {
                returnData.put(fileName, this.readCollection(this.stripRootDir(currentFilePath)));
                continue;
            }
            returnData.put(fileName, this.readDirectory(this.stripRootDir(currentFilePath)));
        }
        return returnData;
    }

    private List<File> removeMetaFile(List<File> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!VABPathTools.getLastElement(list.get(i).getName()).equals("_meta")) continue;
            list.remove(i);
            break;
        }
        return list;
    }

    private String stripRootDir(String path) {
        return path.substring(this.rootDir.length() + 1);
    }

    private void addCollectionToMetaFile(String directoryPath, String collectionName) throws ProviderException {
        HashSet<String> collections = this.readMetaFile(directoryPath);
        if (collections != null) {
            collections.add(collectionName);
        } else {
            collections = new HashSet<String>(Arrays.asList(collectionName));
        }
        this.serializeAndSave(this.rootDir + "/" + directoryPath + "/_meta", collections);
    }

    private void writeObject(String path, Object o) throws ProviderException {
        path = this.unifyPath(path);
        String directory = VABPathTools.getParentPath(path);
        String fullPath = this.rootDir + "/" + path;
        Collection collection = null;
        if (o instanceof Collection) {
            collection = (Collection)o;
        }
        if (collection != null) {
            this.addCollectionToMetaFile(directory, VABPathTools.getLastElement(path));
            this.createDirectory(fullPath);
            Iterator iterator = collection.iterator();
            ArrayList<Integer> references = new ArrayList<Integer>();
            int counter = 0;
            while (iterator.hasNext()) {
                Object item = iterator.next();
                references.add(counter);
                if (item instanceof Map) {
                    this.createDirectory(this.constructCollectionRefPath(fullPath, counter));
                    this.fromMapToDirectory(this.constructCollectionRefPath(path, counter), (Map)item);
                } else {
                    this.serializeAndSave(this.constructCollectionRefPath(fullPath, counter), item);
                }
                ++counter;
            }
            this.writeReferences(fullPath, references);
        } else {
            this.createDirectory(this.rootDir + "/" + directory);
            this.serializeAndSave(fullPath, o);
        }
    }

    private void createDirectory(String path) throws ProviderException {
        try {
            this.fileSystem.createDirectory(path);
        }
        catch (IOException e) {
            throw new ProviderException("Directory \"" + path + "\" could not be created.");
        }
    }

    private void deleteDirectory(String path) throws ProviderException {
        try {
            this.fileSystem.deleteDirectory(path);
        }
        catch (IOException e) {
            throw new ProviderException("Directory \"" + path + "\" could not be deleted.");
        }
    }

    private void deleteFile(String path) throws ProviderException {
        try {
            this.fileSystem.deleteFile(path);
        }
        catch (IOException e) {
            throw new ProviderException("File \"" + path + "\" could not be deleted.");
        }
    }

    private void fromMapToDirectory(String path, Map<String, Object> map) throws ProviderException {
        path = this.unifyPath(path);
        String fullPath = this.rootDir + "/" + path;
        this.createDirectory(fullPath);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.fromMapToDirectory(path + "/" + entry.getKey(), (Map)entry.getValue());
                continue;
            }
            this.writeObject(path + "/" + entry.getKey(), entry.getValue());
        }
    }

    private void writeReferences(String path, List<Integer> ref) throws ProviderException {
        this.serializeAndSave(path + "/references", ref);
    }

    private List<Integer> readReferences(String path) throws ProviderException {
        return (List)this.loadAndDeserialize(path + "/references");
    }

    private Object loadAndDeserialize(String path) throws ProviderException {
        try {
            String serialized = this.fileSystem.readFile(path);
            return this.tools.deserialize(serialized);
        }
        catch (NoSuchFileException e) {
            throw new ResourceNotFoundException("File \"" + path + "\" does not exist.");
        }
        catch (IOException e) {
            throw new ProviderException("File \"" + path + "\" could not be read.");
        }
    }

    private void serializeAndSave(String path, Object o) throws ProviderException {
        try {
            this.fileSystem.writeFile(path, this.tools.serialize(o));
        }
        catch (IOException e) {
            throw new ProviderException("File \"" + path + "\" could not be written.");
        }
    }

    @Override
    public synchronized Object getValue(String path) throws ProviderException {
        path = this.unifyPath(path);
        String directory = VABPathTools.getParentPath(path);
        String fileName = VABPathTools.getLastElement(path);
        String fullDirPath = this.rootDir + "/" + directory;
        if (this.fileSystem.getType(fullDirPath) == FileType.DIRECTORY) {
            List<File> directoryFiles;
            try {
                directoryFiles = this.fileSystem.readDirectory(fullDirPath);
            }
            catch (IOException e) {
                throw new MalformedRequestException("Given directory \"" + directory + "\" could not be read.");
            }
            HashSet<String> collections = this.readMetaFile(directory);
            if (collections != null && collections.contains(fileName)) {
                return this.readCollection(path);
            }
            File file = this.findFileInList(directoryFiles, fileName);
            if (file != null) {
                if (file.getType() == FileType.DATA) {
                    return this.loadAndDeserialize(file.getName());
                }
                return this.readDirectory(path);
            }
            if (fileName.matches("byRef_(0|[1-9][0-9]*)")) {
                throw new ResourceNotFoundException("The specified list element \"" + fileName.substring("byRef_".length()) + "\" does not exist.");
            }
        }
        throw new ResourceNotFoundException("The specified element \"" + path + "\" does not exist.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setValue(String path, Object newValue) throws ProviderException {
        path = this.unifyPath(path);
        String fileName = VABPathTools.getLastElement(path);
        String fullPath = this.rootDir + "/" + path;
        HashSet<String> collections = this.readMetaFile(VABPathTools.getParentPath(path));
        FileType type = this.fileSystem.getType(fullPath);
        if (type == FileType.DATA) {
            if (newValue instanceof Map || newValue instanceof Collection) throw new MalformedRequestException("The single value at \"" + path + "\" can not be replaced with a Map or Collection");
            this.serializeAndSave(fullPath, newValue);
            return;
        } else {
            if (type != FileType.DIRECTORY) throw new ResourceNotFoundException("Value \"" + path + "\" does not exist.");
            if ((collections == null || !collections.contains(fileName)) && newValue instanceof Map) {
                this.deleteDirectory(fullPath);
                this.fromMapToDirectory(path, (Map)newValue);
                return;
            } else {
                this.deleteDirectory(fullPath);
                this.writeObject(path, newValue);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void createValue(String path, Object newEntity) throws ProviderException {
        path = this.unifyPath(path);
        String parentPath = VABPathTools.getParentPath(path);
        String fileName = VABPathTools.getLastElement(path);
        if (this.fileSystem.getType(this.rootDir + "/" + parentPath) == null) {
            throw new ResourceNotFoundException("Parent-path for \"" + path + "\" does not exist.");
        }
        String fullPath = this.rootDir + "/" + path;
        FileType type = this.fileSystem.getType(fullPath);
        if (type == FileType.DATA) {
            throw new ResourceAlreadyExistsException("Could not create a value for \"" + path + "\" because a value already exists");
        }
        if (type == FileType.DIRECTORY) {
            HashSet<String> collections = this.readMetaFile(parentPath);
            if (collections == null || !collections.contains(fileName)) throw new ResourceAlreadyExistsException("At given path \"" + path + "\" exists a Map.");
            List<Integer> references = this.readReferences(fullPath);
            int max = 0;
            for (Integer i : references) {
                if (i <= max) continue;
                max = i;
            }
            if (newEntity instanceof Map) {
                this.fromMapToDirectory(this.constructCollectionRefPath(path, max + 1), (Map)newEntity);
            } else {
                if (newEntity instanceof Collection) throw new MalformedRequestException("The given newEntity is a Collection and can therefore not be added to the existing Collection \"" + path + "\".");
                this.serializeAndSave(this.constructCollectionRefPath(fullPath, max + 1), newEntity);
            }
            references.add(max + 1);
            this.writeReferences(fullPath, references);
            return;
        } else {
            if (type != null) return;
            if (newEntity instanceof Map) {
                this.fromMapToDirectory(path, (Map)newEntity);
                return;
            } else {
                this.writeObject(path, newEntity);
            }
        }
    }

    @Override
    public synchronized void deleteValue(String path) throws ProviderException {
        path = this.unifyPath(path);
        String directory = VABPathTools.getParentPath(path);
        String fileName = VABPathTools.getLastElement(path);
        String fullDirPath = this.rootDir + "/" + directory;
        String fullPath = this.rootDir + "/" + path;
        HashSet<String> collections = this.readMetaFile(directory);
        FileType type = this.fileSystem.getType(fullPath);
        if (type == FileType.DATA) {
            this.deleteFile(fullPath);
            if (fileName.matches("byRef_(0|[1-9][0-9]*)")) {
                int deletedElementIndex = Integer.parseInt(fileName.substring("byRef_".length()));
                List<Integer> references = this.readReferences(fullDirPath);
                references.remove((Object)deletedElementIndex);
                this.writeReferences(fullDirPath, references);
            }
            return;
        }
        if (type == FileType.DIRECTORY) {
            if (collections != null && collections.contains(fileName)) {
                collections.remove(fileName);
                this.serializeAndSave(fullDirPath + "/_meta", collections);
            }
            this.deleteDirectory(fullPath);
            return;
        }
        throw new ResourceNotFoundException("Value \"" + path + "\" can not be deleted as it does not exist.");
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        path = this.unifyPath(path);
        String directory = VABPathTools.getParentPath(path);
        String fileName = VABPathTools.getLastElement(path);
        String fullCollectionPath = this.rootDir + "/" + path;
        HashSet<String> collections = this.readMetaFile(directory);
        FileType type = this.fileSystem.getType(this.rootDir + "/" + directory);
        if (collections != null && type == FileType.DIRECTORY && collections.contains(fileName)) {
            List<Integer> references = this.readReferences(fullCollectionPath);
            for (int i = 0; i < references.size(); ++i) {
                LinkedHashMap<String, Object> o;
                int j = references.get(i);
                String currentPath = this.constructCollectionRefPath(fullCollectionPath, j);
                type = this.fileSystem.getType(currentPath);
                if (type == FileType.DATA) {
                    o = this.loadAndDeserialize(currentPath);
                    if (!((Object)o).equals(obj)) continue;
                    this.deleteFile(currentPath);
                    references.remove((Object)j);
                    this.writeReferences(fullCollectionPath, references);
                    return;
                }
                if (type != FileType.DIRECTORY || !((Object)(o = this.readDirectory(this.constructCollectionRefPath(path, j)))).equals(obj)) continue;
                this.deleteDirectory(currentPath);
                references.remove((Object)j);
                this.writeReferences(fullCollectionPath, references);
                return;
            }
            throw new ResourceNotFoundException("Specified Object was not found in Collection \"" + path + "\".");
        }
        throw new MalformedRequestException("No Collection found at path \"" + path + "\". Delete by value is only possible in Collections.");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        throw new MalformedRequestException("Invoke not supported by filesystem");
    }
}

