/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LogLevel;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.json.TestJson;

public class JsonTest {
    @Test
    public void testJson() throws IOException {
        Json json = Json.createInstance();
        Assert.assertTrue((boolean)(json instanceof TestJson));
        Json.setPrototype((Json)json);
        Json.createInstance(Object.class);
        Json.createInstance((Class[])new Class[]{Object.class, Integer.class});
        Json.createInstance4All();
        Json.createArrayBuilder();
        Json.createObjectBuilder();
        Json.parse((String)"");
        Json.parse((byte[])"".getBytes());
        Json.writeValueAsStringDflt(null);
        Json.writeValueAsBytesDflt(null);
        Json.toJsonDflt(null);
        Json.readValueDflt((String)"{}", Object.class);
        Json.readValueDflt((byte[])"{}".getBytes(), Object.class);
        Json.fromJsonDflt(null, Object.class);
        Json.listFromJsonDflt(null, Object.class);
        Json.mapFromJsonDflt(null, String.class, Object.class);
        Json.createObject((String)"");
        Json.createObject((byte[])"".getBytes());
        Json.createObject((Reader)null);
        Json.createGenerator((Writer)null);
        Json.createEnumValueMap(JsonIterator.ValueType.class);
        json.toJsonQuiet(null);
        json.createEnumValueMapping(LogLevel.class);
        json.createEnumMapping(LogLevel.class);
    }

    @Test
    public void testJsonIter() throws IOException {
        Json.parse((byte[])new byte[0]);
        Json.parse((String)"");
    }

    @Test
    public void testJsonUtils() {
        Data data = new Data();
        data.setiValue(120);
        data.setsValue("xyz");
        Data data2 = (Data)JsonUtils.fromJson((Object)JsonUtils.toJson((Object)data), Data.class);
        Assert.assertNotNull((Object)data2);
        Assert.assertEquals((long)data.getiValue(), (long)data2.getiValue());
        Assert.assertEquals((Object)data.getsValue(), (Object)data2.getsValue());
        Assert.assertNull((Object)JsonUtils.fromJson(null, Data.class));
        Assert.assertEquals((Object)"", (Object)JsonUtils.toJson(null));
        JsonUtils.listFromJson(null, Object.class);
        JsonUtils.mapFromJson(null, String.class, Object.class);
        String txt = "\"\n\t\r\\\b\f\u0081";
        Assert.assertEquals((Object)txt, (Object)JsonUtils.unescape((String)JsonUtils.escape((String)txt)));
    }

    public static class Data {
        private int iValue;
        private String sValue;

        public int getiValue() {
            return this.iValue;
        }

        public void setiValue(int iValue) {
            this.iValue = iValue;
        }

        public String getsValue() {
            return this.sValue;
        }

        public void setsValue(String sValue) {
            this.sValue = sValue;
        }
    }
}

